/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMDispatcherServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.ICAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.service.ICMBridgeCAMService;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvResponseImpl;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class CAMAsyncServiceHandler
extends CAMDispatcherServiceHandler
implements ICMBridgeCAMService {
    private static ICMBridgeCAMService serviceInstance;
    private static final Logger LOGGER;
    private static LocalizableException constructionException;

    public CAMAsyncServiceHandler() {
        super(LOGGER, null);
        serviceInstance = this;
    }

    public CAMAsyncServiceHandler(ICAMFlipperConfiguration theCamFlipperConfig) {
        super(LOGGER, theCamFlipperConfig);
        serviceInstance = this;
    }

    public static ICMBridgeCAMService getInstance() throws LocalizableException {
        if (serviceInstance == null) {
            throw constructionException;
        }
        return serviceInstance;
    }

    public static void setInstance(ICMBridgeCAMService anInstance) {
        serviceInstance = anInstance;
    }

    @Override
    public void dispose() {
        super.dispose();
        serviceInstance = null;
    }

    @Override
    boolean getIsCMCam() {
        return true;
    }

    @Override
    public Element invokeImpl(Document requestDoc, String soapAction) {
        MessageContextImpl messageContext = new MessageContextImpl();
        this.setupMessageContext(messageContext, soapAction, requestDoc.getRootElement());
        this.getCAMServiceHandler().invokeImpl(messageContext);
        SoapEnvResponseImpl soapResponse = (SoapEnvResponseImpl)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        return soapResponse.getElement();
    }

    @Override
    public void setupMessageContext(MessageContextImpl messageContext, String soapAction, Element requestElement) {
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapAction", soapAction);
        if (soapAction.endsWith("CAM.auth")) {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.authRequest", Boolean.TRUE);
        } else {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.authRequest", Boolean.FALSE);
        }
        if (soapAction.endsWith("CAM.legacy")) {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.legacyRequest", Boolean.TRUE);
        } else {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.legacyRequest", Boolean.FALSE);
        }
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.requestElement", requestElement);
    }

    static {
        LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor(CAMAsyncServiceHandler.class.getName());
        constructionException = new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVICE_NOT_CONSTRUCTED"));
    }
}

