/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationExceptionUtils;
import com.ibm.cognos.camaaa.internal.auth.soap.ConvertToHeaderResponse;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManagerImpl;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactoryImpl;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ServiceHandlerDispatcher;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManager;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogUtil;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMAsyncServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.ICAMCommonService;
import com.ibm.cognos.camaaa.internal.common.service.ICAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.service.XMLSerializer;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContextImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyRequestContextImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.netflix.config.DynamicStringProperty;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class CAMCommonServiceHandler
implements ICAMCommonService,
Runnable,
Consumer<ConfigurationPropertyFactory> {
    public static final String CAM_LEGACY_SOAP_ACTION = "CAM.legacy";
    private static final String AUDIT_CAM_AAA = "Audit.CAM.AAA";
    private static final String INVOKE_IMPL = "invokeImpl";
    private static final String DYE_TRACE_MANAGER_MBEAN_OBJECT_NAME = "com.cognos:service=camAsyncAA,type=" + DyeTraceManager.class.getSimpleName();
    private static final String CMCAM_HANDLER_CONFIG_FILE = "handlerConfig.xml";
    private static final int OK = 200;
    private static final int AUTHENTICATION_REQD = 401;
    private static final String AAA_GLOBAL_KEY_NAME = "AAA.global";
    private static int dyeTraceRefCount;
    private static Object configureLock;
    private ServiceHandlerDispatcher handlerDispatcher;
    private ConfigurationManager configMgr;
    private boolean aaServiceHandlerInitialized;
    private SoapFaultException initializationSoapFaultException;
    private final AuditLoggerImpl auditLogger;
    private final PerfLoggerImpl perfLogger;
    private NamespaceManagerImpl namespaceManager;
    private DyeTraceManager dyeTraceManager;
    private String rootHandlerConfigFile = "handlerConfig.xml";
    private String myServiceName;
    private ICAMFlipperConfiguration camConfiguration;
    private boolean isCMCam;
    private HandlerInfo additionalHandlerInfo;
    private DynamicStringProperty dynAAAConfig = null;

    public CAMCommonServiceHandler(Logger subclassLog) {
        LogTypedLogger perflogger = LogTypedLogger.getInstance((String)"Perf.CAM.AAA.SRVC", LogPerfIndication.class);
        this.perfLogger = new PerfLoggerImpl(perflogger);
        LogTypedLogger typedlogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
        this.auditLogger = new AuditLoggerImpl(typedlogger);
        this.aaServiceHandlerInitialized = false;
        this.initializationSoapFaultException = new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), CAMCommonServiceHandler.class.toString(), null, "AAA_CAP_SERVICE_NOT_INITIALIZED", (LocalizableMessage)new Message("AAA_SYS_E_SERVICE_NOT_INITIALIZED"));
    }

    @Override
    public void accept(ConfigurationPropertyFactory cpf) {
        this.dynAAAConfig = cpf.getStringProperty(AAA_GLOBAL_KEY_NAME, null);
        String aaaConfig = this.dynAAAConfig.getValue();
        try {
            Document cogStartupDoc = this.camConfiguration.getCogstartupDoc(aaaConfig);
            ICCLConfiguration flipperCclConfiguration = this.getICCLConfig(cogStartupDoc);
            this.configure(flipperCclConfiguration);
            this.dynAAAConfig.addCallback((Runnable)this);
        }
        catch (LocalizableException e) {
            this.aaServiceHandlerInitialized = false;
            this.initializationSoapFaultException = new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), CAMCommonServiceHandler.class.toString(), null, "AAA_CAP_SERVICE_NOT_INITIALIZED", (LocalizableMessage)new Message("AAA_SYS_E_SERVICE_NOT_INITIALIZED"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ICCLConfiguration flipperCclConfiguration) {
        Object object = configureLock;
        synchronized (object) {
            if (this.aaServiceHandlerInitialized) {
                return;
            }
            try {
                boolean isServletCAM = "CAM".equals(this.myServiceName);
                this.setConfigMgr(new ConfigurationManager(flipperCclConfiguration, "./*[local-name()='AAA']/*[local-name()='value']"));
                boolean disableCM = this.getIsCMDisabled();
                if (!disableCM && !this.isCMServiceEnabled(this.camConfiguration.getCclConfiguration())) {
                    this.setConfigMgr(null);
                    return;
                }
                this.namespaceManager = this.getNamespaceManager(isServletCAM, this.isCMCam, disableCM);
                if (!isServletCAM) {
                    this.namespaceManager.init(this.getConfigMgr());
                }
                this.initializeDyeTraceManager();
                HandlerFactoryImpl handlerFactory = new HandlerFactoryImpl(this.namespaceManager, this.dyeTraceManager, this.additionalHandlerInfo);
                this.handlerDispatcher = new ServiceHandlerDispatcher(handlerFactory);
                this.handlerDispatcher.init(this.getHandlerConfigPath(this.isCMCam, disableCM), this.getConfigMgr());
                if (!isServletCAM) {
                    PassportManager.getInstance().configure(this.getConfigMgr(), this.handlerDispatcher.getInternalHandlerDispatcher(), this.dyeTraceManager);
                }
                this.aaServiceHandlerInitialized = true;
            }
            catch (Throwable t) {
                PassportManager.destroyInstance();
                if (this.handlerDispatcher != null) {
                    this.handlerDispatcher.destroy();
                    this.handlerDispatcher = null;
                }
                if (this.namespaceManager != null) {
                    NamespaceManagerImpl.destroyInstance();
                    this.namespaceManager = null;
                }
                if (this.dyeTraceManager != null) {
                    this.unregisterDyeTraceManager();
                    this.dyeTraceManager = null;
                }
                this.setConfigMgr(null);
                this.aaServiceHandlerInitialized = false;
                this.initializationSoapFaultException = new SoapFaultException("Server", (LocalizableMessage)new Message("AAA_CAP_E_SERVER_DID_SOMETHING_WRONG"), CAMCommonServiceHandler.class.toString(), null, "AAA_CAP_SERVICE_NOT_INITIALIZED", (LocalizableMessage)new Message("AAA_SYS_E_SERVICE_NOT_INITIALIZED"), t);
            }
            this.logStartup(this.myServiceName);
        }
    }

    @Override
    public void configure(ICAMFlipperConfiguration theCAMConfiguration, boolean bIsCMCam, String serviceName, HandlerInfo theAdditionalHandlerInfo) {
        this.camConfiguration = theCAMConfiguration;
        this.isCMCam = bIsCMCam;
        this.myServiceName = serviceName;
        this.additionalHandlerInfo = theAdditionalHandlerInfo;
        theCAMConfiguration.whenReady(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(String myServiceName) {
        Object object = configureLock;
        synchronized (object) {
            LogAuditAccessIndication indication;
            if (!this.aaServiceHandlerInitialized) {
                return;
            }
            PassportManager.destroyInstance();
            this.handlerDispatcher.destroy();
            NamespaceManagerImpl.destroyInstance();
            this.unregisterDyeTraceManager();
            this.dyeTraceManager = null;
            LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)AUDIT_CAM_AAA, LogAuditAccessIndication.class);
            if (ipfLogger.isEnabled(50000) && (indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber())) != null) {
                indication.setOperation("StopService");
                indication.setObjectType(myServiceName);
                indication.setLevel(50000);
                indication.setStatus("Success");
                ipfLogger.log((Object)indication);
            }
        }
    }

    private NamespaceManagerImpl getCMCamNamespaceManager(boolean disableCM) throws LocalizableException {
        NamespaceManagerImpl theNamespaceManager = disableCM ? NamespaceManagerImpl.getInstance(null) : NamespaceManagerImpl.getInstance();
        return theNamespaceManager;
    }

    public ConfigurationManager getConfigMgr() {
        return this.configMgr;
    }

    private String getHandlerConfigPath(boolean isCMCam, boolean disableCM) {
        return this.rootHandlerConfigFile;
    }

    private ICCLConfiguration getICCLConfig(Document cogStartupDoc) throws LocalizableException {
        ICCLConfiguration config = null;
        try {
            config = CCLConfigurationFactory.createConfiguration((Element)cogStartupDoc.getRootElement());
            config.init();
        }
        catch (CCLConfigurationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_E_INVALID_GLOBAL_CONFIG"), (Throwable)e);
        }
        return config;
    }

    private boolean getIsCMDisabled() {
        boolean disableCM = false;
        if (this.configMgr != null) {
            String value = this.configMgr.getOptionalValue("./*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
            disableCM = Boolean.valueOf(value);
        }
        return disableCM;
    }

    private NamespaceManagerImpl getNamespaceManager(boolean isServletCAM, boolean isCMCam, boolean disableCM) throws LocalizableException {
        NamespaceManagerImpl theNamespaceManager = null;
        if (isCMCam) {
            theNamespaceManager = this.getCMCamNamespaceManager(disableCM);
        } else {
            try {
                if (!isServletCAM) {
                    CAMAsyncServiceHandler.getInstance();
                }
                theNamespaceManager = this.getCMCamNamespaceManager(disableCM);
            }
            catch (LocalizableException e) {
                theNamespaceManager = NamespaceManagerImpl.getInstance(null);
            }
        }
        return theNamespaceManager;
    }

    private void initializeDyeTraceManager() throws Exception {
        this.dyeTraceManager = DyeTraceManager.getInstance(this.namespaceManager);
        if (dyeTraceRefCount == 0) {
            MBeanServer mBeanServer = PogoMBeanServer.getInstance().getServer();
            mBeanServer.registerMBean(this.dyeTraceManager, new ObjectName(DYE_TRACE_MANAGER_MBEAN_OBJECT_NAME));
        }
        ++dyeTraceRefCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeImpl(MessageContextImpl messageContext) {
        boolean isLegacyRequest = (Boolean)messageContext.get("com.ibm.cognos.camaaa.internal.common.service.legacyRequest");
        Element requestElement = (Element)messageContext.get("com.ibm.cognos.camaaa.internal.common.service.requestElement");
        Object requestContext = null;
        requestContext = isLegacyRequest ? new LegacyRequestContextImpl(requestElement) : new RequestContextImpl(requestElement);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext", requestContext);
        Object perfIndication = this.perfLogEntry(INVOKE_IMPL, requestContext.getLogContext());
        SoapEnvResponseImpl soapEnvelopeResp = null;
        soapEnvelopeResp = isLegacyRequest ? new LegacySoapEnvelopeResponseImpl(requestElement, (RequestContext)requestContext) : new SoapEnvelopeResponseImpl(requestElement, (RequestContext)requestContext);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", soapEnvelopeResp);
        this.ipfLogEnter(INVOKE_IMPL, requestElement, "requestElement", (RequestContext)requestContext);
        SoapFaultException theException = null;
        try {
            if (!this.aaServiceHandlerInitialized) {
                this.perfLogExit(perfIndication, INVOKE_IMPL);
                throw this.initializationSoapFaultException;
            }
            this.processRequest(messageContext, requestElement);
            if (!isLegacyRequest) {
                ConvertToHeaderResponse.createHeaderResponse((SoapEnvelopeResponseImpl)soapEnvelopeResp, requestContext);
            }
        }
        catch (SoapFaultException e) {
            theException = e;
        }
        catch (Exception e) {
            theException = new InternalErrorException(CAMCommonServiceHandler.class.toString(), e);
        }
        finally {
            messageContext.unlockPassports();
        }
        if (theException != null) {
            theException = AuthenticationExceptionUtils.convertToAuthenticationFaultIfRequired(theException, messageContext);
            soapEnvelopeResp.setFaultEntry((SoapFault)theException, messageContext);
            if (!isLegacyRequest) {
                ConvertToHeaderResponse.createHeaderResponse((SoapEnvelopeResponseImpl)soapEnvelopeResp, requestContext);
            }
        }
        this.ipfLogExit(INVOKE_IMPL, soapEnvelopeResp, (RequestContext)requestContext);
        this.perfLogExit(perfIndication, INVOKE_IMPL);
    }

    public int invokeRestValidate(String passportId) throws SoapFaultException {
        if (!this.aaServiceHandlerInitialized) {
            throw this.initializationSoapFaultException;
        }
        int status = this.isPassportValid(passportId) ? 200 : 401;
        return status;
    }

    private boolean isPassportValid(String passportId) {
        Passport thePassport = PassportManager.getInstance().getPassport(passportId);
        if (thePassport == null) {
            return false;
        }
        boolean isValid = false;
        try {
            if (thePassport.trylock()) {
                thePassport.unlock();
            }
            isValid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isValid;
    }

    private void ipfLogEnter(String functionName, Element entryToLog, String parameterName, RequestContext requestContext) {
        if (this.auditLogger.isEnabled(10000)) {
            LogDataImpl theLogData = (LogDataImpl)this.auditLogger.getLogData();
            theLogData.init(functionName);
            Element loggableElement = LogUtil.getLoggableSoapEnvelope(entryToLog);
            theLogData.addParameter(parameterName, loggableElement.asXML());
            this.auditLogger.logEnter(requestContext.getLogContext(), ComponentImpl.getInstance(), 10000, theLogData);
        }
    }

    private void ipfLogExit(String functionName, SoapEnvelopeResponse entryToLog, RequestContext requestContext) {
        if (this.auditLogger.isEnabled(10000)) {
            LogDataImpl theLogData = (LogDataImpl)this.auditLogger.getLogData();
            theLogData.init(INVOKE_IMPL);
            theLogData.setReturnValue(entryToLog.toXML());
            this.auditLogger.logExit(requestContext.getLogContext(), ComponentImpl.getInstance(), 10000, theLogData);
        }
    }

    private boolean isCMServiceEnabled(ICCLConfiguration cclConfiguration) throws LocalizableException {
        ConfigurationManager configManager = new ConfigurationManager(cclConfiguration, "./*[local-name()='CBS']/*[local-name()='value']");
        String value = configManager.getOptionalValue("./*[local-name()='parameter'][@name=\"cmIsEnabled\"]/*[local-name()='value']/text()", Boolean.TRUE.toString());
        return Boolean.valueOf(value);
    }

    private void logStartup(String myServiceName) {
        LogAuditAccessIndication indication;
        LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)AUDIT_CAM_AAA, LogAuditAccessIndication.class);
        if (ipfLogger.isEnabled(50000) && (indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber())) != null) {
            this.logStartupIndication(ipfLogger, indication, myServiceName);
        }
    }

    private void logStartupIndication(LogTypedLogger ipfLogger, LogAuditAccessIndication indication, String myServiceName) {
        indication.setOperation("StartService");
        indication.setObjectType(myServiceName);
        if (this.aaServiceHandlerInitialized) {
            indication.setStatus("Success");
        } else {
            indication.setStatus("Failure");
            RequestContextImpl requestContext = new RequestContextImpl((Element)null);
            Element messagesElement = XMLSerializer.generateMessagesElement((SoapFault)this.initializationSoapFaultException, requestContext);
            if (messagesElement != null) {
                indication.setErrorMessage(LogDataImpl.toCompactNoDeclarationUtf8String(messagesElement));
            }
        }
        indication.setLevel(50000);
        ipfLogger.log((Object)indication);
    }

    private Object perfLogEntry(String functionName, LogContext logContext) {
        Object retval = null;
        if (this.perfLogger.isEnabled(50000)) {
            LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
            perfLogData.init(functionName);
            retval = this.perfLogger.logEnter(logContext, ComponentImpl.getInstance(), 50000, CAMCommonServiceHandler.class.getName(), functionName, "sequenceID", perfLogData);
        }
        return retval;
    }

    private void perfLogExit(Object indication, String functionName) {
        if (this.perfLogger.isEnabled(50000)) {
            LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
            perfLogData.init(functionName);
            this.perfLogger.logExit(indication, perfLogData);
        }
    }

    @Override
    public void ping() throws SoapFaultException {
        if (!this.aaServiceHandlerInitialized) {
            throw this.initializationSoapFaultException;
        }
    }

    private void processRequest(MessageContextImpl messageContext, Element requestElement) throws LocalizableException {
        boolean isLegacyRequest = (Boolean)messageContext.get("com.ibm.cognos.camaaa.internal.common.service.legacyRequest");
        SoapEnvRequestImpl soapEnvelopeReq = null;
        soapEnvelopeReq = isLegacyRequest ? new LegacySoapEnvelopeRequestImpl(requestElement) : new SoapEnvelopeRequestImpl(requestElement);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest", soapEnvelopeReq);
        this.handlerDispatcher.handleRequest(messageContext, soapEnvelopeReq.getBody().getBodyEntry().getType());
    }

    public synchronized void reconfigure(ICCLConfiguration cclConfiguration) {
        if (!this.aaServiceHandlerInitialized) {
            return;
        }
        try {
            this.getConfigMgr().reconfigure(cclConfiguration);
        }
        catch (LocalizableException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        LogContextImpl theLogContext;
        block4: {
            theLogContext = new LogContextImpl("System", "", 1, "");
            String functionname = "CAMCommonServiceHandler.run()";
            if (this.auditLogger.isEnabled(10000)) {
                LogDataImpl theLogData = (LogDataImpl)this.auditLogger.getLogData();
                theLogData.init("CAMCommonServiceHandler.run()");
                this.auditLogger.logEnter(theLogContext, ComponentImpl.getInstance(), 10000, theLogData);
            }
            String aaaConfig = this.dynAAAConfig.getValue();
            try {
                Document cogStartupDoc = this.camConfiguration.getCogstartupDoc(aaaConfig);
                ICCLConfiguration cclConfiguration = this.getICCLConfig(cogStartupDoc);
                this.reconfigure(cclConfiguration);
            }
            catch (LocalizableException e) {
                if (!this.auditLogger.isEnabled(10000)) break block4;
                LogDataImpl theLogData = (LogDataImpl)this.auditLogger.getLogData();
                theLogData.init("CAMCommonServiceHandler.run()");
                theLogData.addParameter("exception", e.getLocalizedMessage());
                this.auditLogger.logExit(theLogContext, ComponentImpl.getInstance(), 10000, theLogData);
            }
        }
        if (this.auditLogger.isEnabled(10000)) {
            LogDataImpl theLogData = (LogDataImpl)this.auditLogger.getLogData();
            theLogData.init("CAMCommonServiceHandler.run()");
            this.auditLogger.logExit(theLogContext, ComponentImpl.getInstance(), 10000, theLogData);
        }
    }

    public void setConfigMgr(ConfigurationManager configManager) {
        this.configMgr = configManager;
    }

    public void setRootHandlerConfigFile(String file) {
        this.rootHandlerConfigFile = file;
    }

    private void unregisterDyeTraceManager() {
        if (dyeTraceRefCount == 1) {
            try {
                MBeanServer mBeanServer = PogoMBeanServer.getInstance().getServer();
                ObjectName objectName = new ObjectName(DYE_TRACE_MANAGER_MBEAN_OBJECT_NAME);
                if (mBeanServer.isRegistered(objectName)) {
                    mBeanServer.unregisterMBean(objectName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        --dyeTraceRefCount;
    }

    static {
        configureLock = new Object();
    }
}

