/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.service.CAMCommonServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.CAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.service.ICAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.service.ZIPINotifier;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import javax.mail.internet.InternetHeaders;
import org.apache.log.Logger;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class CAMDispatcherServiceHandler
extends BasicHandler
implements Asyncable {
    private final CAMCommonServiceHandler camHandler;
    private ICAMFlipperConfiguration camFlipperConfig;

    public CAMDispatcherServiceHandler(Logger subclassLog, ICAMFlipperConfiguration theCamFlipperConfig) {
        super(subclassLog);
        this.camFlipperConfig = theCamFlipperConfig;
        this.camHandler = new CAMCommonServiceHandler(subclassLog);
    }

    public synchronized void configure(Configuration theConfiguration) {
        if (theConfiguration == null) {
            return;
        }
        this.configure(theConfiguration.getICCLConfiguration());
    }

    public void configure(Configuration theConfiguration, String rootHandlerConfigFile) {
        this.camHandler.setRootHandlerConfigFile(rootHandlerConfigFile);
        this.configure(theConfiguration);
    }

    public void configure(ICCLConfiguration cclConfiguration) {
        HandlerInfo additionalHandlerInfo = ZIPINotifier.makeHandlerInfo();
        ICAMFlipperConfiguration theCamFlipperConfig = null;
        theCamFlipperConfig = this.camFlipperConfig == null ? new CAMFlipperConfiguration(cclConfiguration) : this.camFlipperConfig;
        this.getCAMServiceHandler().configure(theCamFlipperConfig, this.getIsCMCam(), this.getName(), additionalHandlerInfo);
    }

    public synchronized void dispose() {
        this.camHandler.dispose(this.getName());
    }

    public AsyncService getAsyncRequest(MessageContext dispMC) {
        return null;
    }

    private BIBusEnvelope getBIBusEnvelopeForResponse(Element soapResponse) throws DocumentException {
        Element respHeader = (Element)DocumentHelper.selectSingleNode((String)"/SOAP-ENV:Envelope/SOAP-ENV:Header", (Node)soapResponse);
        Element respBody = (Element)DocumentHelper.selectSingleNode((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body", (Node)soapResponse);
        if (respHeader != null) {
            respHeader.detach();
        }
        if (respBody != null) {
            respBody.detach();
        }
        return new BIBusEnvelope(respHeader, respBody);
    }

    protected CAMCommonServiceHandler getCAMServiceHandler() {
        return this.camHandler;
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        BIBusEnvelope respEnv;
        String soapAction = (String)mc.getProperty("request.soapaction");
        BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
        Element requestElement = requestEnv.getEnvelope();
        MessageContextImpl messageContext = new MessageContextImpl();
        this.setupMessageContext(messageContext, soapAction, requestElement);
        this.camHandler.invokeImpl(messageContext);
        SoapEnvResponseImpl soapEnvelopeResponse = (SoapEnvResponseImpl)messageContext.get("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        try {
            respEnv = this.getBIBusEnvelopeForResponse(soapEnvelopeResponse.getElement());
        }
        catch (DocumentException e) {
            throw new PogoException("Internal error", (Exception)((Object)e));
        }
        this.populateDispatcherContext(mc, (SoapEnvelope)soapEnvelopeResponse, respEnv);
    }

    private void populateDispatcherContext(MessageContext mc, SoapEnvelope soapEnvelopeResp, BIBusEnvelope respEnv) {
        if (soapEnvelopeResp.getBody().getBodyEntry().getType() == 19) {
            mc.setFault(new Fault("", (SOAPEnvelope)respEnv));
        } else {
            mc.setResponseName("response");
            mc.setProperty("response.status_code", (Object)"200");
            mc.setProperty("response.envelope", (Object)respEnv);
            InternetHeaders headers = new InternetHeaders();
            headers.setHeader("Content-Type", "text/xml; charset=utf-8");
            mc.setProperty("response.headers", (Object)headers);
            mc.setProperty("response.boundary", null);
            mc.setProperty("response.attachments", null);
        }
    }

    public void reconfigure(Configuration theConfiguration) {
    }

    abstract void setupMessageContext(MessageContextImpl var1, String var2, Element var3);

    abstract boolean getIsCMCam();
}

