/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.ICAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.function.Consumer;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class CAMFlipperConfiguration
implements ICAMFlipperConfiguration {
    private ICCLConfiguration cclConfig;

    public CAMFlipperConfiguration(ICCLConfiguration theCclConfig) {
        this.cclConfig = theCclConfig;
    }

    @Override
    public ICCLConfiguration getCclConfiguration() {
        return this.cclConfig;
    }

    @Override
    public void whenReady(Consumer<ConfigurationPropertyFactory> configConsumer) {
        ConfigurationPropertyFactory.whenReady(configConsumer);
    }

    @Override
    public Document getCogstartupDoc(String globalAAAConfig) throws LocalizableException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><crn:parameters xmlns:crn=\"http://developer.cognos.com/schemas/crconfig/1/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:cfg=\"http://developer.cognos.com/schemas/configparams/XMLSchema/1/\" version=\"173.0\" xsi:schemaLocation=\"http://developer.cognos.com/schemas/crconfig/1/ cogstartup.xsd\">");
        this.addInternalDispatcher(sb);
        sb.append(globalAAAConfig);
        sb.append("</crn:parameters>");
        Document cogStartupDoc = null;
        try {
            cogStartupDoc = DocumentHelper.parseText((String)sb.toString());
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_E_INVALID_GLOBAL_CONFIG"), (Throwable)e);
        }
        return cogStartupDoc;
    }

    private void addInternalDispatcher(StringBuilder sb) {
        try {
            String internalDispatcher = this.cclConfig.getValue("internalDispatcher", false);
            if (internalDispatcher != null && internalDispatcher.length() > 0) {
                sb.append("<crn:parameter name=\"internalDispatcher\">");
                sb.append("<crn:value xsi:type=\"cfg:localURI\">");
                sb.append(internalDispatcher);
                sb.append("</crn:value></crn:parameter>");
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
    }
}

