/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.CAMPassport;
import com.cognos.pogo.pdk.common.Cam;
import com.cognos.pogo.pdk.common.EnvironmentVars;
import com.cognos.pogo.pdk.common.HdrSession;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMDispatcherServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.ICAMFlipperConfiguration;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class CAMStandAloneServiceHandler
extends CAMDispatcherServiceHandler {
    private static final Logger LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor(CAMStandAloneServiceHandler.class.getName());
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(\\w+-\\w+-\\d+)\\s+(.*)");
    private static final String JSON_CONTENT_TYPE = "Content-Type: application/json; charset=utf-8";
    private static final int OK = 200;
    private static final int AUTHENTICATION_REQD = 401;
    private static final int INT_SERVER_ERROR = 500;

    public CAMStandAloneServiceHandler() {
        super(LOGGER, null);
    }

    public CAMStandAloneServiceHandler(ICAMFlipperConfiguration theCamFlipperConfig) {
        super(LOGGER, theCamFlipperConfig);
    }

    private String getExpiryTime() {
        int respValid = 240;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar current = Calendar.getInstance();
        current.add(13, 240);
        return dateFormat.format(current.getTime());
    }

    @Override
    boolean getIsCMCam() {
        return false;
    }

    @Override
    public void invokeImpl(MessageContext mc) throws PogoException {
        String crlf = "\r\n";
        String soapAction = (String)mc.getProperty("request.soapaction");
        if (soapAction.equals("sacam")) {
            BIBusEnvelope requestEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            BiBusHeader biBusHeader = requestEnv.getBiBusHeader();
            Cam cam = biBusHeader.getCam();
            CAMPassport camPassport = cam.getCAMPassport();
            String passportId = camPassport.getId();
            StringBuilder dispAttachment = new StringBuilder();
            int status = 401;
            try {
                status = this.getCAMServiceHandler().invokeRestValidate(passportId);
            }
            catch (SoapFaultException e1) {
                status = 500;
                this.getFailureResponse("\r\n", biBusHeader, dispAttachment, e1);
            }
            mc.setResponseName("response");
            mc.setProperty("response.status_code", (Object)Integer.toString(status));
            mc.setProperty("response.envelope", (Object)requestEnv);
            if (status == 200) {
                this.getValidResponse("\r\n", dispAttachment);
            }
            ArrayList<ByteArrayInputStream> attachements = new ArrayList<ByteArrayInputStream>();
            try {
                attachements.add(new ByteArrayInputStream(dispAttachment.toString().getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            mc.setProperty("response.attachments", attachements.iterator());
        } else {
            super.invokeImpl(mc);
        }
    }

    private void getFailureResponse(String crlf, BiBusHeader biBusHeader, StringBuilder dispAttachment, SoapFaultException e1) {
        HdrSession hdrSession = biBusHeader.getHdrSession();
        EnvironmentVars envVars = hdrSession.getEnvironmentVars();
        String acceptLang = envVars.getValue("HTTP_ACCEPT_LANGUAGE");
        String[] langs = acceptLang.split("[,;]");
        LocalizableMessage[] messages = e1.getLocalizableMessageStack();
        dispAttachment.append(JSON_CONTENT_TYPE);
        dispAttachment.append(crlf);
        dispAttachment.append(crlf);
        dispAttachment.append("{\"errors\": [");
        boolean first = true;
        for (LocalizableMessage aMessage : messages) {
            String localizedMessage = aMessage.getLocalizedMessage(new Locale(langs[0]));
            Matcher matcher = MESSAGE_PATTERN.matcher(localizedMessage);
            String errorCode = "";
            if (matcher.matches()) {
                errorCode = matcher.group(1);
            }
            if (first) {
                first = false;
            } else {
                dispAttachment.append(",");
            }
            dispAttachment.append("{\"code\": \"");
            dispAttachment.append(errorCode);
            dispAttachment.append("\",\"message\": \"");
            dispAttachment.append(localizedMessage);
            dispAttachment.append("\",\"level\": \"error\",\"description\": \"\",\"more_info\": \"\"}");
        }
        dispAttachment.append("]}");
    }

    private void getValidResponse(String crlf, StringBuilder dispAttachment) {
        String expiryTime = this.getExpiryTime();
        dispAttachment.append(JSON_CONTENT_TYPE);
        dispAttachment.append(crlf);
        dispAttachment.append("Expires: ");
        dispAttachment.append(expiryTime);
        dispAttachment.append(crlf);
        dispAttachment.append(crlf);
        dispAttachment.append("{\"expires\": \"");
        dispAttachment.append(expiryTime);
        dispAttachment.append("\"}");
    }

    @Override
    void setupMessageContext(MessageContextImpl messageContext, String soapAction, Element requestElement) {
        messageContext.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapAction", soapAction);
        if (soapAction.contains("sacamsrvc-auth")) {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.authRequest", new Boolean(true));
        } else {
            messageContext.put("com.ibm.cognos.camaaa.internal.common.service.authRequest", new Boolean(false));
        }
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.legacyRequest", Boolean.FALSE);
        messageContext.put("com.ibm.cognos.camaaa.internal.common.service.requestElement", requestElement);
    }
}

