/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import com.ibm.cognos.camaaa.internal.common.NamespaceManagerForTest;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.CAMCommonServiceHandler;
import com.ibm.cognos.camaaa.internal.common.service.CAMFlipperConfiguration;
import com.ibm.cognos.camaaa.internal.common.service.ICAMCommonService;
import com.ibm.cognos.camaaa.internal.common.service.ITrustedRequestValidator;
import com.ibm.cognos.camaaa.internal.common.service.TrustedRequestValidator;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class CAMStandAloneServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 5648269347368722775L;
    private static final Logger LOGGER = Hierarchy.getDefaultHierarchy().getLoggerFor(CAMStandAloneServlet.class.getName());
    private static final String SUCCESS = "Success";
    private static final String FAILED = "Failed";
    private ITrustedRequestValidator trustedReqValidator;
    private final ICAMCommonService camHandler;
    private String myServiceName;

    public CAMStandAloneServlet() {
        this.camHandler = new CAMCommonServiceHandler(LOGGER);
        this.trustedReqValidator = new TrustedRequestValidator(new String[]{"config-service"});
    }

    CAMStandAloneServlet(ICAMCommonService theHandler, ITrustedRequestValidator theTrustedReqValidator) {
        this.camHandler = theHandler;
        this.trustedReqValidator = theTrustedReqValidator;
    }

    public void destroy() {
        super.destroy();
        this.camHandler.dispose(this.myServiceName);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block5: {
            resp.setContentType("application/json");
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.length() > 0) {
                try {
                    if ("/ping".equals(pathInfo)) {
                        this.camHandler.ping();
                        resp.setStatus(200);
                        JsonObject jsonResp = new JsonObject();
                        jsonResp.put("status", (Object)"ok");
                        PrintWriter out = resp.getWriter();
                        out.println(jsonResp.toString());
                        break block5;
                    }
                    resp.setStatus(501);
                }
                catch (SoapFaultException sfe) {
                    resp.setStatus(503);
                    this.setExceptionResponse(resp, (LocalizableException)((Object)sfe), req.getLocale());
                }
            } else {
                resp.setStatus(501);
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block7: {
            Locale locale = req.getLocale();
            resp.setContentType("application/json");
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.length() > 0) {
                try {
                    if ("/test".equals(pathInfo)) {
                        String trustedRequestValue = req.getHeader("X-CA-Authorization");
                        if (trustedRequestValue == null || trustedRequestValue.length() == 0) {
                            throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_TRUSTED_REQUEST_REQUIRED"));
                        }
                        this.trustedReqValidator.verifyTrustedRequest(trustedRequestValue);
                        JsonArray jsonRequest = this.getJsonRequest(req);
                        JsonArray nsTestResp = new JsonArray();
                        ArrayList namespacesToTest = jsonRequest.items(null);
                        for (JsonObject nsTest : namespacesToTest) {
                            this.prepareAndTestNamespace(req, nsTestResp, nsTest, locale);
                        }
                        resp.setStatus(200);
                        PrintWriter out = resp.getWriter();
                        out.println(nsTestResp.toString());
                        break block7;
                    }
                    resp.setStatus(501);
                }
                catch (LocalizableException le) {
                    resp.setStatus(400);
                    this.setExceptionResponse(resp, le, locale);
                }
            } else {
                resp.setStatus(501);
            }
        }
    }

    private Document getCogstartupDocForNamespace(JsonObject nsTest, String nsId) throws LocalizableException {
        String nsInstance = nsTest.getString("instance");
        if (nsInstance == null || nsInstance.isEmpty()) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_INVALID_NAMESPACE_CONFIGURATION", (Object[])new String[]{nsId}));
        }
        String cogStartupHdr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><crn:parameters xmlns:crn=\"http://developer.cognos.com/schemas/crconfig/1/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:cfg=\"http://developer.cognos.com/schemas/configparams/XMLSchema/1/\" version=\"173.0\" xsi:schemaLocation=\"http://developer.cognos.com/schemas/crconfig/1/ cogstartup.xsd\"><crn:parameter name=\"AAA\" opaque=\"true\"><crn:value><crn:instances name=\"authProvider\">";
        String cogStartupEnd = "</crn:instances></crn:value></crn:parameter></crn:parameters>";
        Document cogStartupDoc = null;
        try {
            cogStartupDoc = DocumentHelper.parseText((String)("<?xml version=\"1.0\" encoding=\"UTF-8\"?><crn:parameters xmlns:crn=\"http://developer.cognos.com/schemas/crconfig/1/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:cfg=\"http://developer.cognos.com/schemas/configparams/XMLSchema/1/\" version=\"173.0\" xsi:schemaLocation=\"http://developer.cognos.com/schemas/crconfig/1/ cogstartup.xsd\"><crn:parameter name=\"AAA\" opaque=\"true\"><crn:value><crn:instances name=\"authProvider\">" + nsInstance + "</crn:instances></crn:value></crn:parameter></crn:parameters>"));
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_INVALID_NAMESPACE_CONFIGURATION", (Object[])new String[]{nsId}), (Throwable)e);
        }
        return cogStartupDoc;
    }

    private void getExceptionAsJson(LocalizableException le, JsonObject jsonResp, Locale locale) {
        jsonResp.put("message", (Object)le.getLocalizableMessage().getLocalizedMessage(locale));
        LocalizableMessage[] locMsgs = le.getLocalizableMessageStack();
        if (locMsgs != null && locMsgs.length > 0) {
            JsonArray msgDetails = new JsonArray();
            for (LocalizableMessage locMsg : locMsgs) {
                msgDetails.add((Object)locMsg.getLocalizedMessage(locale));
            }
            jsonResp.put("messageDetails", (Object)msgDetails);
        }
    }

    private void getExceptionAsJson(Exception e, JsonObject jsonResp) {
        jsonResp.put("message", (Object)e.getLocalizedMessage());
        Throwable theCause = e.getCause();
        if (theCause != null) {
            JsonArray theCauseDetails = new JsonArray();
            do {
                theCauseDetails.add((Object)theCause.getLocalizedMessage());
            } while ((theCause = theCause.getCause()) != null);
            jsonResp.put("theCauseDetails", (Object)theCauseDetails);
        }
    }

    private ICCLConfiguration getICCLConfigForNamespace(Document cogStartupDoc, String nsId) throws LocalizableException {
        ICCLConfiguration config = null;
        try {
            config = CCLConfigurationFactory.createConfiguration((Element)cogStartupDoc.getRootElement());
            config.init();
        }
        catch (CCLConfigurationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_INVALID_NAMESPACE_CONFIGURATION", (Object[])new String[]{nsId}), (Throwable)e);
        }
        return config;
    }

    private JsonArray getJsonRequest(HttpServletRequest req) throws InvalidRequestException {
        JsonArray jsonRequest = null;
        try {
            String requestType = req.getContentType();
            if (!"application/json".equals(requestType)) {
                throw new InvalidRequestException(CAMStandAloneServlet.class.toString(), (LocalizableMessage)new Message("AAA_REQ_E_INVALID_CONTENT_TYPE", (Object[])new String[]{requestType}));
            }
            BufferedReader reader = req.getReader();
            jsonRequest = (JsonArray)new JsonParser().parse((Reader)reader);
        }
        catch (Exception e) {
            throw new InvalidRequestException(CAMStandAloneServlet.class.toString(), (LocalizableMessage)new Message("AAA_REQ_E_ERROR_PARSING_REQUEST"), e);
        }
        if (jsonRequest == null) {
            throw new InvalidRequestException(CAMStandAloneServlet.class.toString(), (LocalizableMessage)new Message("AAA_REQ_E_ERROR_PARSING_REQUEST"));
        }
        return jsonRequest;
    }

    public void init(ServletConfig config) throws ServletException {
        ICCLConfiguration cclConfiguration = CCLConfigurationFactory.getInstance();
        this.init(config, cclConfiguration);
    }

    public void init(ServletConfig config, ICCLConfiguration cclConfiguration) throws ServletException {
        super.init(config);
        this.initializePogo(cclConfiguration);
        this.myServiceName = config == null ? CAMStandAloneServlet.class.getName() : config.getServletName();
        CAMFlipperConfiguration camFlipperConfig = new CAMFlipperConfiguration(cclConfiguration);
        this.camHandler.configure(camFlipperConfig, false, this.myServiceName, null);
    }

    private void initializePogo(ICCLConfiguration cclConfiguration) {
        SAXReaderPool.prepare((boolean)false, (int)0);
    }

    private void prepareAndTestNamespace(HttpServletRequest req, JsonArray nsTestResp, JsonObject nsTest, Locale locale) {
        JsonObject nsJsonResp = new JsonObject();
        String nsId = null;
        try {
            nsId = nsTest.getString("id");
            if (nsId == null || nsId.isEmpty()) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_INVALID_NAMESPACE_CONFIGURATION", (Object[])new String[]{"<unknown>"}));
            }
            Document cogStartupDoc = this.getCogstartupDocForNamespace(nsTest, nsId);
            ICCLConfiguration config = this.getICCLConfigForNamespace(cogStartupDoc, nsId);
            this.testNamespace(req, nsId, nsJsonResp, config, locale);
        }
        catch (LocalizableException le) {
            nsJsonResp.put("id", (Object)nsId);
            nsJsonResp.put("status", (Object)FAILED);
            this.getExceptionAsJson(le, nsJsonResp, locale);
        }
        catch (Exception e) {
            nsJsonResp.put("id", (Object)nsId);
            nsJsonResp.put("status", (Object)FAILED);
            this.getExceptionAsJson(e, nsJsonResp);
        }
        nsTestResp.add((Object)nsJsonResp);
    }

    private void setExceptionResponse(HttpServletResponse resp, LocalizableException le, Locale locale) throws IOException {
        JsonObject jsonResp = new JsonObject();
        this.getExceptionAsJson(le, jsonResp, locale);
        PrintWriter out = resp.getWriter();
        out.println(jsonResp.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNamespace(HttpServletRequest req, String nsId, JsonObject nsJsonResp, ICCLConfiguration config, Locale locale) throws LocalizableException {
        NamespaceManagerForTest nsMgr = null;
        try {
            ConfigurationManager camConfig = new ConfigurationManager(config, "./*[local-name()='AAA']/*[local-name()='value']");
            nsMgr = new NamespaceManagerForTest();
            nsMgr.init(camConfig, nsId);
            nsJsonResp.put("id", (Object)nsId);
            nsJsonResp.put("status", (Object)SUCCESS);
            nsJsonResp.put("message", (Object)new Message("AAA_CAP_NAMESPACE_TEST_SUCCESSFUL").getLocalizedMessage(locale));
        }
        finally {
            if (nsMgr != null) {
                nsMgr.destroy();
            }
        }
    }
}

