/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.cognos.accman.jcam.crypto.BATrustedRequestSession;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.service.ITrustedRequestValidator;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashSet;
import java.util.Set;

public class TrustedRequestValidator
implements ITrustedRequestValidator {
    private BATrustedRequestSession cryptoTRSession;
    private Set<String> acceptedServiceNames;
    private Object cryptoTRSessionLock = new Object();

    public TrustedRequestValidator(String[] theAcceptedServiceNames) {
        this.cryptoTRSession = null;
        this.setupAcceptedServiceNamees(theAcceptedServiceNames);
    }

    TrustedRequestValidator(BATrustedRequestSession trs, String[] theAcceptedServiceNames) {
        this.cryptoTRSession = trs;
        this.setupAcceptedServiceNamees(theAcceptedServiceNames);
    }

    private void setupAcceptedServiceNamees(String[] theAcceptedServiceNames) {
        this.acceptedServiceNames = new HashSet<String>();
        for (String anAcceptedServiceName : theAcceptedServiceNames) {
            this.acceptedServiceNames.add(anAcceptedServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyTrustedRequest(String theTrustedValue) throws LocalizableException {
        if (this.cryptoTRSession == null) {
            Object object = this.cryptoTRSessionLock;
            synchronized (object) {
                if (this.cryptoTRSession == null) {
                    try {
                        CAMFactory cf = new CAMFactory("CAMAAA");
                        this.cryptoTRSession = cf.createBATrustedSession();
                    }
                    catch (CAMCryptoException e) {
                        throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_TRUSTED_REQUEST_REQUIRED"), (Throwable)e);
                    }
                }
            }
        }
        try {
            String serviceId = this.cryptoTRSession.getServiceIDAndVerifyToken(theTrustedValue);
            if (!this.acceptedServiceNames.contains(serviceId)) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_TRUSTED_REQUEST_REQUIRED"));
            }
        }
        catch (CAMCryptoException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_REQ_E_TRUSTED_REQUEST_REQUIRED"), (Throwable)e);
        }
    }
}

