/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.service;

import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.exception.AuthenticationException;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.NegotiateException;
import com.ibm.cognos.camaaa.internal.auth.exception.SelectOption;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public final class XMLSerializer {
    private static final String EXCEPTION_XPATH = "./*[local-name()='detail']/*[local-name()='exception']";
    private static final String PROMPT_INFO_XPATH = "./*[local-name()='detail']/*[local-name()='exception']/*[local-name()='promptInfo']";
    private static final String CAPTION = "caption";
    private static final String CAPTIONS = "captions";
    private static final String DEFAULT = "default";
    private static final String DETAIL = "detail";
    private static final String DISPLAY_OBJECTS = "displayObjects";
    private static final String ERRORCODE = "errorCode";
    private static final String ERRORCODESTRING = "errorCodeString";
    private static final String EXCEPTION = "exception";
    private static final String FAULT = "Fault";
    private static final String FAULT_ACTOR = "faultactor";
    private static final String FAULT_CODE = "faultcode";
    private static final String FAULT_STRING = "faultstring";
    private static final String ID = "id";
    private static final String ITEM = "item";
    private static final String MESSAGE_STRING = "messageString";
    private static final String MESSAGES = "messages";
    private static final String NAME = "name";
    private static final String NESTING_LEVEL = "nestingLevel";
    private static final String PROMPTINFO = "promptInfo";
    private static final String PROMPTOPTIONS = "promptOptions";
    private static final String SECURITYBLOB = "securityBlob";
    private static final String SEVERITY = "severity";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String PRESERVE = "preserve";
    private static final String ERROR = "error";
    private static final String SOAP_ENCODING_NS_PREFIX = "SOAP-ENC";
    private static final String XSD_NS_PREFIX = "xsd";
    private static final String BUS_DISPLAYOBJECT = "bus:displayObject";
    private static final String BUS_EXCEPTION = "bus:exception";
    private static final String BUS_MESSAGE = "bus:message";
    private static final String BUS_PROMPTINFO = "bus:promptInfo";
    private static final String BUS_PROMPTOPTION = "bus:promptOption";
    private static final String SOAPENC_ARRAY = "SOAP-ENC:Array";
    private static final String SOAPENC_ARRAYTYPE = "SOAP-ENC:arrayType";
    private static final String XML_SPACE = "xml:space";
    private static final String XSI_TYPE = "xsi:type";
    private static final String XSD_BASE64BINARY = "xsd:base64Binary";
    private static final String XSD_INTEGER = "xsd:integer";
    private static final String BUS_SEVERITY = "bus:severityEnum";
    private static final String XSD_STRING = "xsd:string";
    private static final String XSD_BOOLEAN = "xsd:boolean";
    private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final QName BODY_FAULT_QNAME = QName.get((String)"Fault", (String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName MESSAGES_QNAME = QName.get((String)"messages");

    private XMLSerializer() {
    }

    private static Element createArrayChildElement(Element parent, String name, String arrayType) {
        Element element = parent.addElement(name);
        element.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
        element.addAttribute(SOAPENC_ARRAYTYPE, arrayType);
        return element;
    }

    private static void createSecurityBlobElement(Element promptInfoElement, SecurityBlob theSecurityBlob) {
        if (theSecurityBlob.getBlobType() != -1) {
            Element element = promptInfoElement.addElement(SECURITYBLOB);
            element.addAttribute(XSI_TYPE, XSD_BASE64BINARY);
            String encodedBlob = theSecurityBlob.getEncodedSecurityBlob();
            if (encodedBlob != null) {
                element.addText(encodedBlob);
            } else {
                element.addText("");
            }
        }
    }

    private static void createSpacePreservedStringChildElement(Element parent, String name, String value) {
        XMLSerializer.createSpacePreservedChildElement(parent, name, value, XSD_STRING);
    }

    private static void createSpacePreservedChildElement(Element parent, String name, String value, String type) {
        Element element = parent.addElement(name);
        element.addAttribute(XSI_TYPE, type);
        element.addAttribute(XML_SPACE, PRESERVE);
        element.addText(value);
    }

    public static Element generateMessagesElement(SoapFault theException, RequestContext requestContext) {
        Element messageElement = null;
        LocalizableMessage[] theMessages = theException.getFaultDetail();
        if (theMessages != null) {
            int numOfMessages = theMessages.length;
            messageElement = DocumentHelper.createElement((QName)MESSAGES_QNAME);
            messageElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            messageElement.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
            messageElement.addNamespace(SOAP_ENCODING_NS_PREFIX, "http://schemas.xmlsoap.org/soap/encoding/");
            messageElement.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
            String busMessage = "bus:message[" + numOfMessages + "]";
            messageElement.addAttribute(SOAPENC_ARRAYTYPE, busMessage);
            for (int i = 0; i < numOfMessages; ++i) {
                Element element;
                Element itemElement = messageElement.addElement(ITEM);
                itemElement.addAttribute(XSI_TYPE, BUS_MESSAGE);
                if (i > 0) {
                    element = itemElement.addElement(NESTING_LEVEL);
                    element.addAttribute(XSI_TYPE, XSD_INTEGER);
                    element.addText(new Integer(i).toString());
                }
                element = itemElement.addElement(MESSAGE_STRING);
                element.addAttribute(XSI_TYPE, XSD_STRING);
                element.addAttribute(XML_SPACE, PRESERVE);
                Locale theProductLocale = requestContext.getProductLocale();
                element.addText(theMessages[i].getLocalizedMessage(theProductLocale));
            }
        }
        return messageElement;
    }

    public static Element serialize(NegotiateException theException, RequestContext requestContext) {
        Element rootElement = XMLSerializer.serializeAuthenticationException((AuthenticationException)theException, requestContext);
        Element promptInfoElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)PROMPT_INFO_XPATH, (Node)rootElement);
        byte[] securityContext = theException.getSecurityContext();
        if (securityContext != null) {
            SecurityBlob securityBlob = SecurityBlobManager.createSecurityBlob(securityContext);
            XMLSerializer.createSecurityBlobElement(promptInfoElement, securityBlob);
        }
        return rootElement;
    }

    public static Element serialize(SoapFault theException, RequestContext requestContext) {
        Element rootElement = null;
        rootElement = theException instanceof UserRecoverableException ? XMLSerializer.serialize((UserRecoverableException)theException, requestContext) : (theException instanceof SystemRecoverableException ? XMLSerializer.serialize((SystemRecoverableException)theException, requestContext) : (theException instanceof NegotiateException ? XMLSerializer.serialize((NegotiateException)theException, requestContext) : (theException instanceof UnrecoverableException ? XMLSerializer.serialize((UnrecoverableException)theException, requestContext) : XMLSerializer.serializeSoapFault(theException, requestContext))));
        return rootElement;
    }

    public static Element serialize(SystemRecoverableException theException, RequestContext requestContext) {
        Element rootElement = XMLSerializer.serializeAuthenticationException((AuthenticationException)theException, requestContext);
        Element promptInfoElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)PROMPT_INFO_XPATH, (Node)rootElement);
        byte[] securityContext = theException.getSecurityContext();
        String[] requestedVars = theException.getRequestedVars();
        if (securityContext != null || requestedVars != null) {
            SecurityBlob securityBlob = null;
            if (requestedVars != null) {
                securityBlob = SecurityBlobManager.createSecurityBlob(requestedVars, null);
            } else if (securityContext != null) {
                securityBlob = SecurityBlobManager.createSecurityBlob(securityContext);
            }
            XMLSerializer.createSecurityBlobElement(promptInfoElement, securityBlob);
        }
        XMLSerializer.serializeDisplayObject((SoapFaultException)theException, requestContext, promptInfoElement);
        return rootElement;
    }

    public static Element serialize(UnrecoverableException theException, RequestContext requestContext) {
        Element rootElement = XMLSerializer.serializeAuthenticationException((AuthenticationException)theException, requestContext);
        return rootElement;
    }

    public static Element serialize(UserRecoverableException theException, RequestContext requestContext) {
        Element rootElement = XMLSerializer.serializeAuthenticationException((AuthenticationException)theException, requestContext);
        Element promptInfoElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)PROMPT_INFO_XPATH, (Node)rootElement);
        XMLSerializer.serializeDisplayObject((SoapFaultException)theException, requestContext, promptInfoElement);
        return rootElement;
    }

    private static Element serializeAuthenticationException(AuthenticationException theException, RequestContext requestContext) {
        Element rootElement = XMLSerializer.serializeSoapFault((SoapFault)theException, requestContext);
        Element exceptionElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)EXCEPTION_XPATH, (Node)rootElement);
        Element promptInfoElement = exceptionElement.addElement(PROMPTINFO);
        promptInfoElement.addAttribute(XSI_TYPE, BUS_PROMPTINFO);
        LocalizableMessage[] theCaptions = theException.getCaptions();
        if (theCaptions != null) {
            int numOfCaptions = theCaptions.length;
            Element captionsElement = promptInfoElement.addElement(CAPTIONS);
            captionsElement.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
            String xsdString = "xsd:string[" + numOfCaptions + "]";
            captionsElement.addAttribute(SOAPENC_ARRAYTYPE, xsdString);
            for (int i = 0; i < numOfCaptions; ++i) {
                Element element = captionsElement.addElement(ITEM);
                element.addAttribute(XSI_TYPE, XSD_STRING);
                element.addAttribute(XML_SPACE, PRESERVE);
                Locale theProductLocale = requestContext.getProductLocale();
                element.addText(theCaptions[i].getLocalizedMessage(theProductLocale));
            }
        }
        return rootElement;
    }

    private static void serializeDisplayObject(SoapFaultException theException, RequestContext requestContext, Element promptInfoElement) {
        DisplayObject[] theDisplayObjects = theException.getDisplayObjects();
        if (theDisplayObjects != null && theDisplayObjects.length > 0) {
            int numOfDisplayObjects = theDisplayObjects.length;
            Element displayObjectElement = promptInfoElement.addElement(DISPLAY_OBJECTS);
            displayObjectElement.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
            String busDisplayObject = "bus:displayObject[" + numOfDisplayObjects + "]";
            displayObjectElement.addAttribute(SOAPENC_ARRAYTYPE, busDisplayObject);
            for (int i = 0; i < numOfDisplayObjects; ++i) {
                SelectOption[] theOptions;
                String theValue;
                Element itemElement = displayObjectElement.addElement(ITEM);
                itemElement.addAttribute(XSI_TYPE, BUS_DISPLAYOBJECT);
                XMLSerializer.createSpacePreservedStringChildElement(itemElement, TYPE, theDisplayObjects[i].getType());
                XMLSerializer.createSpacePreservedStringChildElement(itemElement, NAME, theDisplayObjects[i].getName());
                String theCaption = theDisplayObjects[i].getCaption(requestContext.getProductLocale());
                if (theCaption != null) {
                    XMLSerializer.createSpacePreservedStringChildElement(itemElement, CAPTION, theCaption);
                }
                if ((theValue = theDisplayObjects[i].getValue()) != null) {
                    XMLSerializer.createSpacePreservedStringChildElement(itemElement, VALUE, theValue);
                }
                if ((theOptions = theDisplayObjects[i].getOptions()) == null) continue;
                int numOfSelectOptions = theOptions.length;
                Element promptOptionsElement = XMLSerializer.createArrayChildElement(itemElement, PROMPTOPTIONS, "bus:promptOption[" + numOfSelectOptions + "]");
                for (int j = 0; j < numOfSelectOptions; ++j) {
                    Element itemElement2 = promptOptionsElement.addElement(ITEM);
                    itemElement2.addAttribute(XSI_TYPE, BUS_PROMPTOPTION);
                    XMLSerializer.createSpacePreservedStringChildElement(itemElement2, ID, theOptions[j].getID());
                    XMLSerializer.createSpacePreservedStringChildElement(itemElement2, VALUE, theOptions[j].getValue());
                    XMLSerializer.createSpacePreservedChildElement(itemElement2, DEFAULT, Boolean.toString(theOptions[j].isSelectedByDefault()), XSD_BOOLEAN);
                }
            }
        }
    }

    public static Element serializeException(SoapFault theException, RequestContext requestContext) {
        Element soapFaultElement = XMLSerializer.serialize(theException, requestContext);
        Element exceptionElement = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)EXCEPTION_XPATH, (Node)soapFaultElement);
        exceptionElement.detach();
        String camException = "bus:CAMException";
        exceptionElement.addAttribute(XSI_TYPE, "bus:CAMException");
        return exceptionElement;
    }

    private static Element serializeSoapFault(SoapFault theException, RequestContext requestContext) {
        Element rootElement = DocumentHelper.createElement((QName)BODY_FAULT_QNAME);
        Element element = rootElement.addElement(FAULT_CODE);
        element.addText(theException.getFaultCode());
        element = rootElement.addElement(FAULT_STRING);
        element.addText(theException.getFaultString().getLocalizedMessage(requestContext.getServerLocale()));
        String theFaultActor = theException.getFaultActor();
        if (theFaultActor != null) {
            element = rootElement.addElement(FAULT_ACTOR);
            element.addText(theFaultActor);
        }
        Element detailElement = rootElement.addElement(DETAIL);
        Element exceptionElement = detailElement.addElement(EXCEPTION);
        exceptionElement.addNamespace(SOAP_ENCODING_NS_PREFIX, "http://schemas.xmlsoap.org/soap/encoding/");
        exceptionElement.addNamespace(XSD_NS_PREFIX, XSD_NS_URI);
        exceptionElement.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        exceptionElement.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        exceptionElement.addAttribute(XSI_TYPE, BUS_EXCEPTION);
        element = exceptionElement.addElement(SEVERITY);
        element.addAttribute(XSI_TYPE, BUS_SEVERITY);
        element.addText(ERROR);
        if (theException.getErrorCode() != null) {
            element = exceptionElement.addElement(ERRORCODE);
            element.addText(theException.getErrorCode().toString());
        }
        element = exceptionElement.addElement(ERRORCODESTRING);
        element.addAttribute(XSI_TYPE, XSD_STRING);
        element.addAttribute(XML_SPACE, PRESERVE);
        element.addText(theException.getErrorCodeString());
        Element messageElement = XMLSerializer.generateMessagesElement(theException, requestContext);
        if (messageElement != null) {
            exceptionElement.add(messageElement);
        }
        return rootElement;
    }
}

