/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SingleValueExpectedException;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusVariableResolver;
import com.ibm.cognos.camaaa.internal.common.soap.CamSection;
import com.ibm.cognos.camaaa.internal.common.soap.CamSectionImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SetCookieVar;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.jaxen.VariableContext;

public class BiBusHeaderImpl
implements BiBusHeader {
    protected static final QName XSI_TYPE_NS = QName.get((String)"type", (Namespace)NS_XSI);
    private static final String CAM_STR = "CAM";
    private static final String CAM_SECURITY_BLOB_FORM_FIELD = "CAM_SecurityBlob";
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String MAXAGE = "maxAge";
    private static final String DOMAIN = "domain";
    private static final String SECURE = "secure";
    private static final String XSI_TYPE = "xsi:type";
    private static final String PRESERVE = "preserve";
    private static final String HDRSESSION = "hdrSession";
    private static final String FORMFIELDVARS = "formFieldVars";
    private static final String ENVIRONMENTVARS = "environmentVars";
    private static final String COOKIEVARS = "cookieVars";
    private static final String SETCOOKIEVARS = "setCookieVars";
    private static final String ARRAYTYPE = "arrayType";
    private static final String NAME_STR = "name";
    private static final String CAM_CHECK_GATEWAY = "CAMCheckGateway";
    private static final QName CAF = QName.get((String)"CAF");
    private static final QName TRACKING = QName.get((String)"tracking");
    private static final QName SESSION_CONTEXT = QName.get((String)"sessionContext");
    private static final QName SECURE_STATE = QName.get((String)"secureState");
    private static final QName NAME = QName.get((String)"name");
    private static final String GET_VAR_XPATH_EXPR = "./*[camaaa:element-text(*[local-name()='name'])=$name]";
    private static final String GET_VAR_VALUE_XPATH_EXPR = "./*/*[local-name()='name'][camaaa:element-text(.)=$name]/../*[local-name()='value']";
    private static final String GET_VAR_FORMAT_XPATH_EXPR = "./*/*[local-name()='name'][camaaa:element-text(.)=$name]/../*[local-name()='format']";
    private static final String SOAP_ENC = "SOAP-ENC";
    private static final Namespace NS_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace NS_XSI = Namespace.get((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static final QName SOAP_ENC_ARRAYTYPE = QName.get((String)"arrayType", (Namespace)NS_SOAP_ENC);
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String BUS_FORM_FIELD_VAR = "bus:formFieldVar[";
    private static final XPath SECURE_STATE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='secureState']/text()");
    private Element biBusHeader = null;
    private Element hdrSession = null;
    private Element formFieldVars = null;
    private Element environmentVars = null;
    private Element cookieVars = null;
    private Element setCookieVars = null;
    private Element caf = null;
    private Element tracking = null;
    private CamSection cam;
    private final CAMFactory camf = new CAMFactory();
    private EncryptingSession session = null;

    protected BiBusHeaderImpl(Element biBusHdrElement) {
        if (biBusHdrElement != null && biBusHdrElement.getQName().equals((Object)XMLConstants.BIBUS_BIBUSHEADER)) {
            this.biBusHeader = biBusHdrElement;
            Element element = biBusHdrElement.element(HDRSESSION);
            if (element != null) {
                this.hdrSession = element;
                this.formFieldVars = this.getPosiblyQualifiedBusElement(FORMFIELDVARS);
                this.environmentVars = this.getPosiblyQualifiedBusElement(ENVIRONMENTVARS);
                this.cookieVars = this.getPosiblyQualifiedBusElement(COOKIEVARS);
                this.setCookieVars = this.getPosiblyQualifiedBusElement(SETCOOKIEVARS);
            }
            this.caf = biBusHdrElement.element(CAF.getName());
            this.cam = new CamSectionImpl(this.biBusHeader);
            this.tracking = biBusHdrElement.element(TRACKING.getName());
        }
    }

    static BiBusHeader getBiBusHeader(Element theBiBusHdrParent) {
        BiBusHeaderImpl retval = null;
        Element element = theBiBusHdrParent.element(XMLConstants.BIBUS_BIBUSHEADER);
        if (element != null) {
            retval = new BiBusHeaderImpl(element);
        }
        return retval;
    }

    public void addEnvVar(String name, String value) {
        this.removeEnvVar(name);
        Element item = this.environmentVars.addElement(ITEM);
        Element nameElement = item.addElement(NAME_STR);
        nameElement.setText(name);
        nameElement.addAttribute(XSI_TYPE, "xsd:string");
        nameElement.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
        Element valueElement = item.addElement(VALUE);
        valueElement.setText(value);
        valueElement.addAttribute(XSI_TYPE, "xsd:string");
        valueElement.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
    }

    public void consumeFormField(String theName) {
        if (this.formFieldVars != null) {
            List list = DocumentHelper.selectNodes((String)GET_VAR_XPATH_EXPR, (VariableContext)new BiBusVariableResolver(NAME, theName), (Node)this.formFieldVars);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Node node = (Node)list.get(i);
                    this.formFieldVars.remove(node);
                }
            }
            List elements = this.formFieldVars.elements();
            this.formFieldVars.addAttribute(ARRAYTYPE, BUS_FORM_FIELD_VAR + elements.size() + "]");
        }
    }

    private boolean cookieVariablePairMatches(Object left, Object right) {
        boolean equality = true;
        if (left != null && right != null) {
            if (!left.equals(right)) {
                equality = false;
            }
        } else if (left != right) {
            equality = false;
        }
        return equality;
    }

    private Element createSection(QName section, String biBusPrefix) {
        Element sectionElement = this.biBusHeader.addElement(section);
        DocumentHelper.addMissingAttribute((Element)sectionElement, (QName)XMLConstants.XSI_TYPE, (String)DocumentHelper.createQualifiedElementName((String)biBusPrefix, (String)section.getName()));
        return sectionElement;
    }

    protected Element getBiBusHeaderElement() {
        return this.biBusHeader;
    }

    private String getBiBusPrefix() {
        return this.biBusHeader.getNamespacePrefix();
    }

    public String getCAMPassportID() {
        if (this.cam != null) {
            return this.cam.getCAMPassportID();
        }
        return null;
    }

    public CamSection getCamSection() {
        return this.cam;
    }

    public String getCAMSecurityBlob() {
        String[] blobs = this.getFormFieldValues(CAM_SECURITY_BLOB_FORM_FIELD);
        if (blobs == null || blobs.length == 0 || blobs[0] == null) {
            return this.cam.getCAMSecurityBlob();
        }
        return blobs[0];
    }

    public String getCookieValue(String theName) throws LocalizableException {
        return this.getVarValue(this.cookieVars, theName);
    }

    public String[] getCookieValues(String theName) {
        return this.getVarValues(this.cookieVars, theName);
    }

    public String getEnvVarValue(String theName) throws LocalizableException {
        return this.getVarValue(this.environmentVars, theName);
    }

    public String[] getEnvVarValues(String theName) {
        return this.getVarValues(this.environmentVars, theName);
    }

    public String getFormFieldValue(String theName) throws LocalizableException {
        this.initializeCAMCrypto();
        return this.getVarValue(this.formFieldVars, theName);
    }

    public String[] getFormFieldValues(String theName) {
        return this.getVarValues(this.formFieldVars, theName);
    }

    private String[] getNodeValue(Element theVarsElement, String xPathFilterExpression, String theName, boolean decrypt) {
        String[] retval = null;
        List list = DocumentHelper.selectNodes((String)xPathFilterExpression, (VariableContext)new BiBusVariableResolver(NAME, theName), (Node)theVarsElement);
        if (list != null && list.size() > 0) {
            retval = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element = (Element)list.get(i);
                String value = element.getText();
                if (decrypt) {
                    try {
                        this.initializeCAMCrypto();
                    }
                    catch (LocalizableException e) {
                        throw new RuntimeException(e);
                    }
                    byte[] decodedValue = base64.decode((int)0, (String)value);
                    try {
                        retval[i] = new String(this.session.decryptData(decodedValue), "UTF-8");
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    catch (CAMCryptoException e) {
                        retval[i] = value;
                        continue;
                    }
                }
                retval[i] = value;
            }
        }
        return retval;
    }

    private Element getPosiblyQualifiedBusElement(String name) {
        Element element = this.hdrSession.element(name);
        if (element != null && (element.getNamespaceURI().length() == 0 || element.getNamespaceURI().equals("http://developer.cognos.com/schemas/bibus/3/"))) {
            return element;
        }
        return null;
    }

    public String getSecureState() {
        return DocumentHelper.valueOf((XPath)SECURE_STATE_XPATH, (Node)this.caf);
    }

    public String getSessionContext() {
        if (this.tracking == null) {
            return null;
        }
        Element sessionContextElement = this.tracking.element(SESSION_CONTEXT);
        return sessionContextElement.getText();
    }

    public String[] getSetCookieNames() {
        List list;
        if (this.setCookieVars != null && (list = DocumentHelper.selectNodes((String)"./*/name", (Node)this.setCookieVars)) != null && list.size() > 0) {
            String[] names = new String[list.size()];
            int i = 0;
            for (Node node : list) {
                names[i++] = node.getText();
            }
            return names;
        }
        return null;
    }

    public String getSetCookieValue(String theName) throws LocalizableException {
        SetCookieVar cookie = this.getSetCookieVar(theName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public String[] getSetCookieValues(String theName) {
        SetCookieVar[] cookies = this.getSetCookieVars(theName);
        if (cookies == null) {
            return null;
        }
        String[] retval = new String[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            retval[i] = cookies[i].getValue();
        }
        return retval;
    }

    public SetCookieVar getSetCookieVar(String theName) throws LocalizableException {
        SetCookieVar[] retval = this.getSetCookieVars(theName);
        if (retval == null) {
            return null;
        }
        if (retval.length > 1) {
            throw new SingleValueExpectedException(theName, SETCOOKIEVARS);
        }
        return retval[0];
    }

    public SetCookieVar[] getSetCookieVars(String theName) {
        List list;
        SetCookieVar[] retval = null;
        if (this.setCookieVars != null && (list = DocumentHelper.selectNodes((String)GET_VAR_XPATH_EXPR, (VariableContext)new BiBusVariableResolver(NAME, theName), (Node)this.setCookieVars)) != null && list.size() > 0) {
            retval = new SetCookieVar[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element e = (Element)list.get(i);
                retval[i] = new SetCookieVar(e);
            }
        }
        return retval;
    }

    public String getUserSessionID() {
        return this.cam.getUserSessionID();
    }

    private String getVarValue(Element theNode, String theName) throws LocalizableException {
        String[] value = this.getVarValues(theNode, theName);
        if (value == null || value.length == 0) {
            return null;
        }
        if (value.length == 1) {
            return value[0];
        }
        throw new SingleValueExpectedException(theName, theNode.getPath());
    }

    private String[] getVarValues(Element theVarsElement, String theName) {
        String[] retval = null;
        if (theVarsElement != null) {
            String[] formatValue = this.getNodeValue(theVarsElement, GET_VAR_FORMAT_XPATH_EXPR, theName, false);
            boolean decrypt = false;
            if (formatValue != null && formatValue.length > 0 && formatValue[0].compareToIgnoreCase("encrypted") == 0) {
                decrypt = true;
            }
            retval = this.getNodeValue(theVarsElement, GET_VAR_VALUE_XPATH_EXPR, theName, decrypt);
        }
        return retval;
    }

    private void initializeCAMCrypto() throws LocalizableException {
        if (this.session == null) {
            try {
                this.camf.initialize("<initializeDocument><serviceID>DecryptPassword</serviceID></initializeDocument>".getBytes());
            }
            catch (CAMCryptoException e) {
                throw new FunctionCallFailedException(BiBusHeaderImpl.class.toString(), "CAMFactory.initialize", (Exception)((Object)e));
            }
            try {
                this.session = this.camf.createEncryptingSession();
            }
            catch (CAMCryptoException e) {
                throw new FunctionCallFailedException(BiBusHeaderImpl.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
            }
        }
    }

    private void prepareFormFieldVars() {
        if (this.formFieldVars == null) {
            if (this.hdrSession == null) {
                this.hdrSession = this.biBusHeader.addElement(QName.get((String)HDRSESSION));
            }
            this.formFieldVars = this.hdrSession.addElement(QName.get((String)FORMFIELDVARS));
        }
    }

    private void prepareSetCookieVars() {
        if (this.setCookieVars == null) {
            if (this.hdrSession == null) {
                this.hdrSession = this.biBusHeader.addElement(QName.get((String)HDRSESSION));
            }
            DocumentHelper.addMissingAttribute((Element)this.hdrSession, (QName)XMLConstants.XSI_TYPE, (String)DocumentHelper.createQualifiedElementName((String)this.getBiBusPrefix(), (String)HDRSESSION));
            DocumentHelper.removeAttribute((Element)this.hdrSession, (QName)XMLConstants.XSI_NIL);
            if (this.setCookieVars == null) {
                this.setCookieVars = this.hdrSession.addElement(QName.get((String)SETCOOKIEVARS));
            }
        }
        DocumentHelper.addMissingAttribute((Element)this.setCookieVars, (QName)SOAP_ENC_ARRAYTYPE, (String)DocumentHelper.createQualifiedElementName((String)"bus", (String)"setCookieVar[]"));
        DocumentHelper.addMissingAttribute((Element)this.setCookieVars, (QName)XMLConstants.XSI_TYPE, (String)DocumentHelper.createQualifiedElementName((String)SOAP_ENC, (String)"Array"));
        DocumentHelper.removeAttribute((Element)this.setCookieVars, (QName)XMLConstants.XSI_NIL);
    }

    public void removeEnvVar(String name) {
        String xpath = "./*[*[local-name()='name']='" + name + "']";
        List elements = DocumentHelper.selectElements((String)xpath, (Node)this.environmentVars);
        if (elements != null) {
            for (Element element : elements) {
                this.environmentVars.remove(element);
            }
        }
    }

    private void removeMatchingCookies(String theName, String thePath, String theDomain, Boolean theSecureFlag) {
        List list = DocumentHelper.selectNodes((String)GET_VAR_XPATH_EXPR, (VariableContext)new BiBusVariableResolver(NAME, theName), (Node)this.setCookieVars);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element e = (Element)list.get(i);
                SetCookieVar setCookieVar = new SetCookieVar(e);
                String domain = setCookieVar.getDomain();
                String path = setCookieVar.getPath();
                Boolean secureFlag = setCookieVar.getSecureFlag();
                if (!this.cookieVariablePairMatches(domain, theDomain) || !this.cookieVariablePairMatches(path, thePath) || !this.cookieVariablePairMatches(secureFlag, theSecureFlag)) continue;
                this.setCookieVars.remove(e);
            }
        }
    }

    public void removeNonPropagatableResponseElements() {
        Element camProtect;
        if (this.cam != null) {
            this.cam.removeNonPropagatableResponseElements();
        }
        if ((camProtect = this.biBusHeader.element("CAMProtect")) != null) {
            camProtect.detach();
        }
        if (this.formFieldVars != null) {
            Iterator it = this.formFieldVars.elementIterator();
            while (it.hasNext()) {
                Element item = (Element)it.next();
                Element name = item.element(NAME_STR);
                if (name == null || !name.getText().startsWith(CAM_STR)) continue;
                item.detach();
            }
        }
    }

    public void setCAMCheckGateway() {
        if (this.formFieldVars == null) {
            this.prepareFormFieldVars();
        }
        Element item = this.formFieldVars.addElement(QName.get((String)ITEM));
        Element nameElement = item.addElement(NAME_STR);
        nameElement.setText(CAM_CHECK_GATEWAY);
        nameElement.addAttribute(XSI_TYPE, "xsd:string");
        nameElement.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
        Element valueElement = item.addElement(VALUE);
        valueElement.setText("true");
        valueElement.addAttribute(XSI_TYPE, "xsd:string");
        valueElement.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
        List elements = this.formFieldVars.elements();
        this.formFieldVars.addAttribute(ARRAYTYPE, BUS_FORM_FIELD_VAR + elements.size() + "]");
    }

    public void setCamPassportCookieInfo(String theEncodedCamPassportCookie) {
        this.setCookie(CAM_PASSPORT, theEncodedCamPassportCookie, 0, null, null, null);
        this.cam.setCamPassportCookieInfo(theEncodedCamPassportCookie);
    }

    public void setCAMPassportId(String passportId, Boolean shareable) {
        this.cam.setCamPassportId(passportId, shareable);
    }

    public void setCAMSecurityBlob(String securityBlob) {
        this.consumeFormField(CAM_SECURITY_BLOB_FORM_FIELD);
        this.cam.setCAMSecurityBlob(securityBlob);
    }

    public void setCookie(String theName, String theValue, int theMaxAge, String thePath, String theDomain, Boolean theSecureFlag) {
        if (this.setCookieVars != null) {
            this.removeMatchingCookies(theName, thePath, theDomain, theSecureFlag);
        }
        this.prepareSetCookieVars();
        Element item = this.setCookieVars.addElement(QName.get((String)ITEM));
        item.addAttribute(QName.get((String)XSI_TYPE), DocumentHelper.createQualifiedElementName((String)"bus", (String)"setCookieVar"));
        Element element = item.addElement(NAME);
        element.addAttribute(XSI_TYPE, "xsd:string");
        element.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
        element.addText(theName);
        if (theValue != null) {
            element = item.addElement(VALUE);
            element.addAttribute(XSI_TYPE, "xsd:string");
            element.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
            element.addText(theValue);
        }
        if (thePath != null && thePath.length() > 0) {
            element = item.addElement(PATH);
            element.addAttribute(XSI_TYPE, "xsd:string");
            element.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
            element.addText(thePath);
        }
        element = item.addElement(MAXAGE);
        element.addAttribute(XSI_TYPE, "xsd:int");
        element.addText(Integer.toString(theMaxAge));
        if (theDomain != null && theDomain.length() > 0) {
            element = item.addElement(DOMAIN);
            element.addAttribute(XSI_TYPE, "xsd:string");
            element.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
            element.addText(theDomain);
        }
        if (theSecureFlag != null) {
            element = item.addElement(SECURE);
            element.addAttribute(XSI_TYPE, "xsd:boolean");
            element.addText(theSecureFlag.toString());
        }
        this.setCookieVars.addAttribute(ARRAYTYPE, "bus:setCookieVar[" + this.setCookieVars.elements().size() + "]");
    }

    public void setSecureState(String theSecureState) {
        Element secureStateNode;
        if (theSecureState != null) {
            Element secureStateElement;
            String biBusPrefix = this.getBiBusPrefix();
            if (biBusPrefix == null || biBusPrefix.equals("")) {
                this.biBusHeader.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
                biBusPrefix = "bus";
            }
            if (this.caf == null) {
                this.caf = this.createSection(CAF, biBusPrefix);
            }
            if ((secureStateElement = this.caf.element(SECURE_STATE.getName())) == null) {
                secureStateElement = this.caf.addElement(SECURE_STATE);
                secureStateElement.addAttribute(XSI_TYPE_NS, "xsd:string");
                secureStateElement.addAttribute(XMLConstants.XML_SPACE, PRESERVE);
            }
            secureStateElement.setText(theSecureState);
        } else if (this.caf != null && (secureStateNode = this.caf.element(SECURE_STATE.getName())) != null) {
            this.caf.remove(secureStateNode);
        }
    }

    public void setSessionContext(String sessionID) {
        Element sessionContextElement;
        if (this.tracking == null) {
            this.tracking = this.createSection(TRACKING, this.getBiBusPrefix());
        }
        if ((sessionContextElement = this.tracking.element(SESSION_CONTEXT.getName())) == null) {
            sessionContextElement = this.tracking.addElement(SESSION_CONTEXT);
        }
        if (sessionID != null) {
            sessionContextElement.setText(sessionID);
        }
    }

    public void setUserSessionID(String userSessionID) {
        this.cam.setUserSessionID(userSessionID);
    }
}

