/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizedMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class CMSoapFault
implements SoapFault {
    private final Element soapFaultElement;
    private Element exceptionElement;

    public CMSoapFault(Element theSoapFaultElement) {
        this.soapFaultElement = theSoapFaultElement;
        Element detailElement = this.soapFaultElement.element("detail");
        this.exceptionElement = detailElement != null ? detailElement.element("exception") : null;
    }

    public Integer getErrorCode() {
        try {
            return Integer.valueOf(this.getErrorCodeString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getErrorCodeString() {
        Element errorCodeElement;
        if (this.exceptionElement != null && (errorCodeElement = this.exceptionElement.element("errorCode")) != null) {
            String errorCode = errorCodeElement.getText();
            return errorCode;
        }
        return null;
    }

    public String getFaultActor() {
        Element faultActorElement = this.soapFaultElement.element("faultactor");
        if (faultActorElement != null) {
            String faultActor = faultActorElement.getText();
            return faultActor;
        }
        return null;
    }

    public String getFaultCode() {
        Element faultCodeElement = this.soapFaultElement.element("faultcode");
        if (faultCodeElement != null) {
            String faultCode = faultCodeElement.getText();
            return faultCode;
        }
        return null;
    }

    public LocalizableMessage[] getFaultDetail() {
        ArrayList<LocalizedMessage> messages = new ArrayList<LocalizedMessage>();
        String message = DocumentHelper.valueOf((String)"./bus:message[not(nestingLevel)]/messageString/text()", (Node)this.exceptionElement);
        if (message != null) {
            messages.add(new LocalizedMessage(message));
        }
        XPath subMessageXpath = DocumentHelper.createXPath((String)"../nestingLevel/text()");
        List subMessages = DocumentHelper.selectNodes((String)"./bus:message[nestingLevel]/messageString", (Node)this.exceptionElement);
        subMessageXpath.sort(subMessages);
        for (Node node : subMessages) {
            String subMessage = node.getText();
            if (subMessage == null) continue;
            messages.add(new LocalizedMessage(subMessage));
        }
        return messages.toArray(new LocalizableMessage[0]);
    }

    public LocalizableMessage getFaultString() {
        String faultString;
        Element faultStringElement = this.soapFaultElement.element("faultstring");
        if (faultStringElement != null && (faultString = faultStringElement.getText()) != null) {
            return new LocalizedMessage(faultString);
        }
        return null;
    }

    public int getType() {
        return 19;
    }
}

