/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieImpl;
import com.ibm.cognos.camaaa.internal.common.soap.CamSection;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public class CamSectionImpl
implements CamSection {
    private static final String ANONYMOUS_ALLOWED = "anonymousAllowed";
    private static final String BUS_CAMSETTINGS = "bus:CAMSettings";
    private static final QName CAM = QName.get((String)"CAM");
    private static final String CAM_PASSPORT_STR = "CAMPassport";
    private static final QName CAMPASSPORT = QName.get((String)"CAMPassport");
    private static final String CAN_CALL_LOGON = "canCallLogon";
    private static final String GENERATION = "generation";
    private static final QName ID = QName.get((String)"id");
    private static final String ID_STR = "id";
    private static final String IS_ANONYMOUS = "isAnonymous";
    private static final String LOG_ENABLED = "logEnabled";
    private static final String NAMESPACES_CONFIGURED = "namespacesConfigured";
    private static final QName SECURITY_BLOB_QNAME = QName.get((String)"securityBlob");
    private static final XPath SECURITY_BLOB_XPATH = DocumentHelper.createXPath((String)("./*[local-name()='" + SECURITY_BLOB_QNAME.getName() + "']/text()"));
    private static final String SETTINGS = "settings";
    private static final QName SHAREABLE = QName.get((String)"shareable");
    private static final HashSet<String> TO_REMOVE_FROM_CAM = new HashSet();
    private static final XPath USER_SESSION_ID_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='userSessionID']/text()");
    private static final QName USERSESSIONID = QName.get((String)"userSessionID");
    private static final String XSI_TYPE = "xsi:type";
    private Element biBusHeader;
    private Element cam;

    public CamSectionImpl(Element parentElement) {
        TO_REMOVE_FROM_CAM.add("action");
        TO_REMOVE_FROM_CAM.add("exception");
        TO_REMOVE_FROM_CAM.add(SECURITY_BLOB_QNAME.getName());
        TO_REMOVE_FROM_CAM.add("roles");
        TO_REMOVE_FROM_CAM.add("CAMCredentialPath");
        this.biBusHeader = parentElement;
        this.cam = this.biBusHeader.element(CAM.getName());
    }

    private void createAndFillPassportElement(String passportId, Boolean shareable) {
        Element passportNode = this.prepareCamPassportNode();
        Element id = passportNode.element(ID.getName());
        if (id == null) {
            id = passportNode.addElement(ID);
        }
        DocumentHelper.addMissingAttribute((Element)id, (QName)XMLConstants.XSI_TYPE, (String)"xsd:string");
        DocumentHelper.addMissingAttribute((Element)id, (QName)XMLConstants.XML_SPACE, (String)"preserve");
        DocumentHelper.removeAttribute((Element)id, (QName)XMLConstants.XSI_NIL);
        id.setText(passportId);
        Element shareableElement = passportNode.element(SHAREABLE.getName());
        if (shareableElement == null) {
            shareableElement = passportNode.addElement(SHAREABLE);
        }
        DocumentHelper.addMissingAttribute((Element)shareableElement, (QName)XMLConstants.XSI_TYPE, (String)"xsd:boolean");
        DocumentHelper.addMissingAttribute((Element)shareableElement, (QName)XMLConstants.XML_SPACE, (String)"preserve");
        DocumentHelper.removeAttribute((Element)shareableElement, (QName)XMLConstants.XSI_NIL);
        if (shareable != null) {
            shareableElement.setText(shareable.toString());
        } else {
            shareableElement.setText("false");
        }
    }

    private void createAndFillUserSessionIDElement(String userSessionIDValue) {
        Element userSessionID = this.cam.element(USERSESSIONID.getName());
        if (userSessionID == null) {
            userSessionID = this.cam.addElement(USERSESSIONID);
        }
        DocumentHelper.addMissingAttribute((Element)userSessionID, (QName)XMLConstants.XSI_TYPE, (String)"xsd:base64Binary");
        DocumentHelper.removeAttribute((Element)userSessionID, (QName)XMLConstants.XSI_NIL);
        userSessionID.setText(userSessionIDValue);
    }

    public String getCAMPassportID() {
        if (this.cam != null && !DocumentHelper.isXsiNil((Element)this.cam)) {
            return this.getCAMPassportIDText();
        }
        return null;
    }

    private String getCAMPassportIDText() {
        Element id;
        Element camPassportElement = this.cam.element(CAM_PASSPORT_STR);
        if (camPassportElement != null && !DocumentHelper.isXsiNil((Element)camPassportElement) && (id = camPassportElement.element(ID_STR)) != null && !DocumentHelper.isXsiNil((Element)id)) {
            return id.getText();
        }
        return null;
    }

    public String getCAMSecurityBlob() {
        return DocumentHelper.valueOf((XPath)SECURITY_BLOB_XPATH, (Node)this.cam);
    }

    public String getUserSessionID() {
        return DocumentHelper.valueOf((XPath)USER_SESSION_ID_XPATH, (Node)this.cam);
    }

    private void prepareAndFillCamSettingsElement(CAMCookie camCookie) {
        Element settingsElement = this.cam.element(SETTINGS);
        if (settingsElement == null) {
            settingsElement = this.cam.addElement(SETTINGS);
            settingsElement.addAttribute(XMLConstants.XSI_TYPE, BUS_CAMSETTINGS);
        }
        DocumentHelper.removeAttribute((Element)settingsElement, (QName)XMLConstants.XSI_NIL);
        Element anonymousAllowedElement = settingsElement.element(ANONYMOUS_ALLOWED);
        if (anonymousAllowedElement == null) {
            anonymousAllowedElement = settingsElement.addElement(ANONYMOUS_ALLOWED);
            anonymousAllowedElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:boolean");
        }
        anonymousAllowedElement.setText(Boolean.toString(camCookie.isCamConfiguredForAnonymous()));
        Element namespacesConfiguredElement = settingsElement.element(NAMESPACES_CONFIGURED);
        if (namespacesConfiguredElement == null) {
            namespacesConfiguredElement = settingsElement.addElement(NAMESPACES_CONFIGURED);
            namespacesConfiguredElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:boolean");
        }
        namespacesConfiguredElement.setText(Boolean.toString(camCookie.areCamNamespacesConfigured()));
    }

    private Element prepareCamPassportNode() {
        this.prepareCAMSection();
        Element passportNode = this.cam.element(CAMPASSPORT.getName());
        if (passportNode == null) {
            passportNode = this.cam.addElement(CAMPASSPORT.getName());
        }
        DocumentHelper.addMissingAttribute((Element)passportNode, (QName)XMLConstants.XSI_TYPE, (String)DocumentHelper.createQualifiedElementName((String)this.biBusHeader.getNamespacePrefix(), (String)CAMPASSPORT.getName()));
        DocumentHelper.removeAttribute((Element)passportNode, (QName)XMLConstants.XSI_NIL);
        return passportNode;
    }

    private void prepareCAMSection() {
        if (this.cam == null) {
            this.cam = this.biBusHeader.addElement(CAM);
        }
        DocumentHelper.addMissingAttribute((Element)this.cam, (QName)XMLConstants.XSI_TYPE, (String)DocumentHelper.createQualifiedElementName((String)this.biBusHeader.getNamespacePrefix(), (String)CAM.getName()));
        DocumentHelper.removeAttribute((Element)this.cam, (QName)XMLConstants.XSI_NIL);
    }

    public void removeNonPropagatableResponseElements() {
        if (this.cam != null) {
            Iterator it = this.cam.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String name = element.getName();
                if (!TO_REMOVE_FROM_CAM.contains(name)) continue;
                element.detach();
            }
        }
    }

    public void setCamPassportCookieInfo(String theEncodedCamPassportCookie) {
        Element passportNode = this.prepareCamPassportNode();
        CAMCookie camCookie = CAMCookieImpl.createCookie((String)theEncodedCamPassportCookie);
        Element canCallLogonElement = passportNode.element(CAN_CALL_LOGON);
        if (canCallLogonElement == null) {
            canCallLogonElement = passportNode.addElement(CAN_CALL_LOGON);
            canCallLogonElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:boolean");
        }
        canCallLogonElement.setText(Boolean.toString(camCookie.canCurrentUserCallLogon()));
        Element generationElement = passportNode.element(GENERATION);
        if (generationElement == null) {
            generationElement = passportNode.addElement(GENERATION);
            generationElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:int");
        }
        generationElement.setText(Integer.toString(camCookie.getPassportGeneration()));
        Element logEnabledElement = passportNode.element(LOG_ENABLED);
        if (logEnabledElement == null) {
            logEnabledElement = passportNode.addElement(LOG_ENABLED);
            logEnabledElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:boolean");
        }
        logEnabledElement.setText(Boolean.toString(camCookie.isLoggingEnabled()));
        Element isAnonymousElement = passportNode.element(IS_ANONYMOUS);
        if (isAnonymousElement == null) {
            isAnonymousElement = passportNode.addElement(IS_ANONYMOUS);
            isAnonymousElement.addAttribute(XMLConstants.XSI_TYPE, "xsd:boolean");
        }
        isAnonymousElement.setText(Boolean.toString(camCookie.isCurrentUserAnonymous()));
        this.prepareAndFillCamSettingsElement(camCookie);
    }

    public void setCamPassportId(String passportId, Boolean shareable) {
        Element passportNode;
        if (passportId != null) {
            this.createAndFillPassportElement(passportId, shareable);
        } else if (this.cam != null && (passportNode = this.cam.element(CAMPASSPORT.getName())) != null) {
            this.cam.remove(passportNode);
        }
    }

    public void setCAMSecurityBlob(String securityBlob) {
        Element securityBlobElement;
        if (securityBlob != null) {
            this.prepareCAMSection();
            Element securityBlobElement2 = this.cam.element(SECURITY_BLOB_QNAME.getName());
            if (securityBlobElement2 == null) {
                securityBlobElement2 = this.cam.addElement(SECURITY_BLOB_QNAME);
                securityBlobElement2.addAttribute(XSI_TYPE, "xsd:base64Binary");
            }
            securityBlobElement2.setText(securityBlob);
        } else if (this.cam != null && (securityBlobElement = this.cam.element(SECURITY_BLOB_QNAME.getName())) != null) {
            this.cam.remove(securityBlobElement);
        }
    }

    public void setUserSessionID(String userSessionID) {
        Element userSessionIDNode;
        if (userSessionID != null) {
            this.prepareCAMSection();
            this.createAndFillUserSessionIDElement(userSessionID);
        } else if (this.cam != null && (userSessionIDNode = this.cam.element(USERSESSIONID.getName())) != null) {
            this.cam.remove(userSessionIDNode);
        }
    }

    public void copyCAMPassportTo(Element parent) {
        Element passportNode;
        if (this.cam != null && (passportNode = this.cam.element(CAMPASSPORT.getName())) != null) {
            parent.add(passportNode.createCopy());
        }
    }
}

