/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.util.LocaleUtil;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public class RequestContextImpl
implements RequestContext {
    private static final ICCLConfiguration CCL_CONFIG = CCLConfigurationFactory.getInstance();
    private static final String SESSIONCONTEXT = "sessionContext";
    private static final String REQUESTCONTEXT = "requestContext";
    private static final String HOPCOUNT = "hopCount";
    private static final String STEPCONTEXT = "stepContext";
    private static final String SERVER_LOCALE = "serverLocale";
    private static final String TRACKING_XPATH_EXPRESSION = "./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']";
    private static final XPath TRACKING_XPATH = DocumentHelper.createXPath((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']");
    private static final String LOCALE_XPATH_PREFIX = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/";
    private static final String PRODUCT_LOCALE_XPATH_EXPR = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='productLocale']/../*[local-name()='value']/text()";
    private static final XPath PRODUCT_LOCALE_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='productLocale']/../*[local-name()='value']/text()");
    private static final String CONTENT_LOCALE_XPATH_EXPR = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='contentLocale']/../*[local-name()='value']/text()";
    private static final XPath CONTENT_LOCALE_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='contentLocale']/../*[local-name()='value']/text()");
    private final Locale contentLocale;
    private final Locale productLocale;
    private final Locale serverLocale;
    private final LogContextImpl logContext;

    public RequestContextImpl(Element theSoapEnvelope) {
        String sessionID = null;
        String requestID = null;
        Integer subRequestID = null;
        String stepID = null;
        String productLocaleString = null;
        String contentLocaleString = null;
        String serverLocaleString = null;
        try {
            serverLocaleString = CCL_CONFIG.getValue(SERVER_LOCALE, false);
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        this.serverLocale = LocaleUtil.createLocale((String)serverLocaleString, (Locale)Locale.getDefault());
        if (theSoapEnvelope != null) {
            Element tracking = (Element)DocumentHelper.selectSingleNode((XPath)TRACKING_XPATH, (Node)theSoapEnvelope);
            if (tracking != null) {
                sessionID = tracking.elementText(SESSIONCONTEXT);
                requestID = tracking.elementText(REQUESTCONTEXT);
                String value = tracking.elementText(HOPCOUNT);
                try {
                    subRequestID = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    subRequestID = null;
                }
                stepID = tracking.elementText(STEPCONTEXT);
            }
            if (tracking != null && sessionID != null && requestID == null) {
                requestID = " ";
            }
            productLocaleString = DocumentHelper.valueOf((XPath)PRODUCT_LOCALE_XPATH, (Node)theSoapEnvelope);
            contentLocaleString = DocumentHelper.valueOf((XPath)CONTENT_LOCALE_XPATH, (Node)theSoapEnvelope);
        }
        this.contentLocale = LocaleUtil.createContentLocale(contentLocaleString, (Locale)this.serverLocale);
        this.productLocale = LocaleUtil.createProductLocale(productLocaleString, (Locale)this.serverLocale);
        this.logContext = new LogContextImpl(sessionID, requestID, subRequestID, stepID);
    }

    public RequestContextImpl(RequestContext theRequestContext) {
        this.contentLocale = theRequestContext.getContentLocale();
        this.productLocale = theRequestContext.getProductLocale();
        this.serverLocale = theRequestContext.getServerLocale();
        this.logContext = new LogContextImpl(theRequestContext.getLogContext());
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public Locale getServerLocale() {
        return this.serverLocale;
    }
}

