/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.logging.LogUtil;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeaderFactory;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeaderImpl;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public abstract class SoapEnvRequestImpl
implements SoapEnvelopeRequest {
    private static final XPath SOAP_ENV_BODY_XPATH = DocumentHelper.createXPath((String)"./SOAP-ENV:Body");
    private static final XPath CAM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']");
    private static final XPath CAM_PROTECT_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAMProtect']");
    private SoapHeader header = null;

    protected SoapEnvRequestImpl() {
    }

    public static void removeNonPropagatableRequestElements(Element soapEnv) {
        Node node = null;
        node = DocumentHelper.selectSingleNode((XPath)CAM_PROTECT_XPATH, (Node)soapEnv);
        if (node != null) {
            node.getParent().remove(node);
        }
        if ((node = DocumentHelper.selectSingleNode((XPath)CAM_XPATH, (Node)soapEnv)) != null) {
            node.getParent().remove(node);
        }
    }

    public SoapEnvelope createNewRequest(String theSoapBody) {
        Element soapEnv = this.getElement().createCopy();
        Node bodyNode = DocumentHelper.selectSingleNode((XPath)SOAP_ENV_BODY_XPATH, (Node)soapEnv);
        soapEnv.remove(bodyNode);
        try {
            Document document = DocumentHelper.parseText((String)theSoapBody);
            soapEnv.add(document.getRootElement());
            SoapEnvRequestImpl.removeNonPropagatableRequestElements(soapEnv);
            SoapEnvelopeRequestImpl newRequest = new SoapEnvelopeRequestImpl(soapEnv);
            return newRequest;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        catch (SoapFaultException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract Element getElement();

    public SoapHeader getHeader() {
        return this.header;
    }

    protected void init(Element theSoapEnvelope, BiBusHeaderFactory bbHdrFactory) {
        this.header = null;
        if (theSoapEnvelope.getQName().equals((Object)XMLConstants.SOAPENV_ENVELOPE)) {
            this.header = SoapHeaderImpl.getSoapHeader(theSoapEnvelope, bbHdrFactory);
        }
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        return this.getElement().asXML();
    }

    public String toLoggableXML() {
        return LogUtil.getLoggableSoapEnvelope(this.getElement()).asXML();
    }
}

