/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.AdminBodyRequest;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.AuthBodyRequest;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeaderFactoryImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import org.dom4j.Element;

public class SoapEnvelopeRequestImpl
extends SoapEnvRequestImpl {
    private SoapBody body;
    private final Element soapEnvelope;

    public SoapEnvelopeRequestImpl(Element theSoapEnvelope) throws SoapFaultException {
        super.init(theSoapEnvelope, new BiBusHeaderFactoryImpl());
        this.soapEnvelope = theSoapEnvelope;
        if (theSoapEnvelope.getQName().equals((Object)XMLConstants.SOAPENV_ENVELOPE)) {
            this.body = AuthBodyRequest.getSoapBody(theSoapEnvelope);
            if (this.body == null) {
                this.body = AdminBodyRequest.getSoapBody(theSoapEnvelope);
            }
            if (this.body == null) {
                Message msg = new Message("AAA_REQ_E_MISSING_REQUIRED_ELEMENT", new Object[]{new String("request"), new String("soap body")});
                throw new UnrecoverableException("Client", (LocalizableMessage)msg, (LocalizableMessage)msg);
            }
        }
    }

    public SoapBody getBody() {
        return this.body;
    }

    @Override
    public Element getElement() {
        return this.soapEnvelope;
    }
}

