/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeaderFactoryImpl;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SoapEnvelopeResponseImpl
extends SoapEnvResponseImpl {
    private SoapBodyResponse bodyResponse = null;
    private Element soapEnvelope = null;
    private Element soapEnvBody = null;

    public SoapEnvelopeResponseImpl(Element theSoapEnvelope, RequestContext theRequestContext) {
        if (theSoapEnvelope.getQName().equals((Object)XMLConstants.SOAPENV_ENVELOPE)) {
            this.soapEnvelope = DocumentHelper.createDocument().addElement(XMLConstants.SOAPENV_ENVELOPE);
            Element originalHdrElement = theSoapEnvelope.element(XMLConstants.SOAPENV_HEADER);
            if (originalHdrElement != null) {
                this.soapEnvelope.add(originalHdrElement.createCopy());
            }
            super.init(this.soapEnvelope, new BiBusHeaderFactoryImpl());
            SoapHeader soapHdr = this.getHeader();
            BiBusHeader biBusHdr = null;
            if (soapHdr != null) {
                biBusHdr = soapHdr.getBiBusHeader();
            }
            if (biBusHdr != null) {
                biBusHdr.removeNonPropagatableResponseElements();
            }
            this.bodyResponse = SoapBodyResponse.getSoapBodyResponse(theSoapEnvelope, theRequestContext);
        }
    }

    public SoapBody getBody() {
        return this.bodyResponse;
    }

    @Override
    public Element getElement() {
        if (this.soapEnvBody != null) {
            this.soapEnvelope.remove(this.soapEnvBody);
        }
        this.soapEnvBody = this.bodyResponse.getElement();
        this.soapEnvelope.add(this.soapEnvBody);
        return this.soapEnvelope;
    }

    @Override
    public void setFaultEntry(SoapFault soapFault, MessageContext messageContext) {
        this.bodyResponse.setFaultBodyEntry(soapFault);
    }

    @Override
    public SoapFault getFaultEntry() {
        SoapFault retval = null;
        SoapBodyEntry bodyEntry = this.bodyResponse.getBodyEntry();
        if (bodyEntry.getType() == 19) {
            retval = (SoapFault)bodyEntry;
        }
        return retval;
    }
}

