/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.auth;

import com.ibm.cognos.camaaa.internal.legacy.auth.BaseLegacyVisa;
import java.util.HashMap;
import java.util.Map;

public final class BaseLegacyVisaManager {
    private static BaseLegacyVisaManager instance = new BaseLegacyVisaManager();
    private final Map<Integer, VisaReference> visas = new HashMap<Integer, VisaReference>();

    private BaseLegacyVisaManager() {
    }

    static BaseLegacyVisaManager getInstance() {
        return instance;
    }

    synchronized int addVisa(BaseLegacyVisa visa) {
        VisaReference ref = this.visas.get(visa.getRef());
        if (ref != null) {
            return visa.getRef();
        }
        int refKey = visa.hashCode();
        this.visas.put(refKey, new VisaReference(visa));
        return refKey;
    }

    synchronized void addVisaRef(int theRef) {
        VisaReference ref = this.visas.get(theRef);
        ref.incReferenceCount();
    }

    synchronized BaseLegacyVisa getVisa(int theRef) {
        VisaReference ref = this.visas.get(theRef);
        ref.incReferenceCount();
        return ref.getVisa();
    }

    synchronized boolean removeVisa(int theRef) {
        VisaReference ref = this.visas.get(theRef);
        if (ref != null) {
            int refCount = ref.decReferenceCount();
            if (refCount == 0) {
                this.visas.remove(theRef);
            } else {
                return false;
            }
        }
        return true;
    }

    private class VisaReference {
        private final BaseLegacyVisa visa;
        private int count;

        VisaReference(BaseLegacyVisa theVisa) {
            this.visa = theVisa;
            this.count = 1;
        }

        synchronized int decReferenceCount() {
            return --this.count;
        }

        synchronized BaseLegacyVisa getVisa() {
            return this.visa;
        }

        synchronized void incReferenceCount() {
            ++this.count;
        }
    }
}

