/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.handler.DispatchToNamespaceUtility;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyBiBusHeader;
import java.util.Iterator;
import java.util.Set;

public class LegacyGenerateTCForAuthenticatedNamespaces
extends DefaultHandler {
    private EncryptingSession session;

    private void generateTC(SoapEnvelope response, String credentialString) throws InternalErrorException {
        try {
            byte[] encryptedTCBytes = this.session.encryptData(credentialString.getBytes("UTF8"));
            String encryptedTC = base64.encode((int)0, (byte[])encryptedTCBytes);
            LegacyBiBusHeader bibusHeader = (LegacyBiBusHeader)response.getHeader().getBiBusHeader();
            bibusHeader.setTrustedCredential(this.getEncryptedValueWrapper(encryptedTC));
        }
        catch (Exception e) {
            throw new InternalErrorException(LegacyGenerateTCForAuthenticatedNamespaces.class.toString(), e);
        }
    }

    private String getEncryptedValueWrapper(String theValue) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<credential><encryptedValue>");
        buffer.append(theValue);
        buffer.append("</encryptedValue></credential>");
        return buffer.toString();
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String credentialString = new String();
        SoapEnvelope response = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        Set<String> authenticatedNSIds = passport.getAuthenticatedNamespaceIDs();
        Iterator<String> it = authenticatedNSIds.iterator();
        boolean needToCheckPrimary = true;
        String primaryNSId = passport.getPrimaryNsID();
        while (it.hasNext()) {
            boolean primaryNS = false;
            String nsId = it.next();
            if (nsId.equals("")) {
                credentialString = credentialString + "<credential><namespace></namespace><username></username><password></password></credential>";
                continue;
            }
            if (needToCheckPrimary && authenticatedNSIds.size() > 1 && primaryNSId.compareTo(nsId) == 0) {
                primaryNS = true;
                needToCheckPrimary = false;
            }
            CredentialImpl aCredential = DispatchToNamespaceUtility.generateTC(passport, nsId, primaryNS, theContext);
            credentialString = aCredential.getRootElement().asXML() + credentialString;
        }
        if (authenticatedNSIds.size() > 1) {
            credentialString = "<credentials>" + credentialString + "</credentials>";
        }
        this.generateTC(response, credentialString);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(LegacyGenerateTCForAuthenticatedNamespaces.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
    }
}

