/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.handler.GetCredentialsFromTC;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonTCRequest;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class HdrLogonTCRequestImpl
implements LogonTCRequest {
    private final String trustedCredentials;
    private EncryptingSession session;

    public HdrLogonTCRequestImpl(Element soapHeader) throws SoapFaultException {
        this.trustedCredentials = DocumentHelper.valueOf((String)"./bus:biBusHeader/*[local-name()='CAM']/*[local-name()='CAMTrustedCredential']", (Node)soapHeader);
        CAMFactory camf = new CAMFactory();
        try {
            camf.initialize("<initializeDocument><serviceID>HdrLogonTCRequestImpl</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(GetCredentialsFromTC.class.toString(), "CAMFactory.initialize", (Exception)((Object)e));
        }
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(GetCredentialsFromTC.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
    }

    public String[] getCredentialPath() {
        return null;
    }

    public Credential[] getCredentials() throws SoapFaultException {
        try {
            String encryptedValue = this.getEncryptedCredential();
            byte[] decodedValue = base64.decode((int)0, (String)encryptedValue);
            String decryptedValue = new String(this.session.decryptData(decodedValue), "UTF8");
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(decryptedValue));
            return this.retrieveCredentials(doc.getRootElement());
        }
        catch (Exception e) {
            throw new InternalErrorException(HdrLogonTCRequestImpl.class.toString(), e);
        }
    }

    private String getEncryptedCredential() throws DocumentException {
        Document doc = DocumentHelper.parseText((String)this.trustedCredentials);
        String credential = DocumentHelper.valueOf((String)"./encryptedValue", (Node)doc.getRootElement());
        return credential;
    }

    public int getType() {
        return 22;
    }

    private Credential[] retrieveCredentials(Element rootElement) {
        Credential[] retval = null;
        ArrayList<CredentialImpl> credentials = new ArrayList<CredentialImpl>();
        if (rootElement.getName().equals("credential")) {
            credentials.add(new CredentialImpl(rootElement));
        } else if (rootElement.getName().equals("credentials")) {
            List list = DocumentHelper.selectNodes((String)"./*[local-name()='credential']", (Node)rootElement);
            for (int i = 0; i < list.size(); ++i) {
                Element credential = (Element)list.get(i);
                Element primary = DocumentHelper.selectSingleElement((String)"./*[local-name()='primary']", (Node)credential);
                if (primary != null && primary.getTextTrim().equalsIgnoreCase("true")) {
                    credentials.add(0, new CredentialImpl(credential));
                    continue;
                }
                credentials.add(new CredentialImpl(credential));
            }
        }
        if (!credentials.isEmpty()) {
            retval = credentials.toArray(new Credential[credentials.size()]);
        }
        return retval;
    }
}

