/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequestImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeaderImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyBiBusHeader;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

final class LegacyBiBusHeaderImpl
extends BiBusHeaderImpl
implements LegacyBiBusHeader {
    private static final String NAMESPACE = "namespace";
    private static final String CREDENTIALS = "credentials";
    private static final String CAM = "CAM";
    private static final String CAMTRUSTED_CREDENTIAL_XPATH_EXP = "./*[local-name()='CAMTrustedCredential']";
    private static final XPath CAMTRUSTED_CREDENTIAL_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='CAMTrustedCredential']");
    private static final String CREDENTIAL = "credential";
    private static final String CAM_TRUSTED_CREDENTIAL = "CAMTrustedCredential";
    private static final String CAM_CREDENTIAL = "CAMCredential";
    private static final String XSD_ANYTYPE = "xsd:anyType";
    private static final XPath XPATH_CAM = DocumentHelper.createXPath((String)"./*[local-name()='CAM']");
    private static final HashSet<String> TO_REMOVE_FROM_CAM = new HashSet();
    private Element decodedCredentials;
    private Element credential;
    private List actionsElements;

    private LegacyBiBusHeaderImpl(Element biBusHdrElement) throws SoapFaultException {
        super(biBusHdrElement);
        TO_REMOVE_FROM_CAM.add(CREDENTIALS);
        TO_REMOVE_FROM_CAM.add(CREDENTIAL);
        TO_REMOVE_FROM_CAM.add(CAM_TRUSTED_CREDENTIAL);
        Element biBusHeader = super.getBiBusHeaderElement();
        Element cam = biBusHeader.element(CAM);
        if (cam != null) {
            this.credential = cam.element(CREDENTIAL);
            Element credentialsElement = cam.element(CREDENTIALS);
            Element credentialElement = null;
            if (credentialsElement != null) {
                credentialElement = credentialsElement.element(CREDENTIAL);
            }
            this.decodedCredentials = credentialElement != null ? credentialsElement : this.decodeCredentials(credentialsElement);
            this.actionsElements = cam.elements("action");
        } else {
            this.credential = null;
            this.decodedCredentials = null;
            this.actionsElements = null;
        }
    }

    static LegacyBiBusHeader getLegacyBiBusHeader(Element theBiBusHdrParent) throws SoapFaultException {
        LegacyBiBusHeaderImpl retval = null;
        Element element = theBiBusHdrParent.element(XMLConstants.BIBUS_BIBUSHEADER);
        if (element != null) {
            retval = new LegacyBiBusHeaderImpl(element);
        }
        return retval;
    }

    private static Element xmlDecodeCredentials(String credentials) throws InternalErrorException {
        if (credentials == null || credentials.length() == 0) {
            return null;
        }
        try {
            String value = "<credentials>" + credentials + "</credentials>";
            Document doc = DocumentHelper.parseText((String)value);
            return doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new InternalErrorException(LogonRequestImpl.class.toString(), (Exception)((Object)e));
        }
    }

    private Element decodeCredentials(Element credentials) throws InternalErrorException {
        Element decodedCreds = null;
        if (credentials != null) {
            String encodedCredentials = credentials.getText();
            decodedCreds = LegacyBiBusHeaderImpl.xmlDecodeCredentials(encodedCredentials);
        }
        return decodedCreds;
    }

    private Node extractNSParentNodeFromDecodedCredentials(String theNamespaceID, String endOfXpath) {
        Element namespaceElement;
        Node node = DocumentHelper.selectSingleNode((String)("/*/*[*[local-name()='namespace'][camaaa:element-text(.)='" + theNamespaceID + endOfXpath), (Node)this.decodedCredentials);
        if (node == null && (namespaceElement = (Element)DocumentHelper.selectSingleNode((String)("./*/*[local-name()='namespace'][text()='" + theNamespaceID + "']"), (Node)this.decodedCredentials)) != null) {
            node = namespaceElement.getParent();
        }
        return node;
    }

    @Override
    public String getAction() throws SoapFaultException {
        if (this.actionsElements == null) {
            return null;
        }
        String action = null;
        int actionsElementsSize = this.actionsElements.size();
        if (this.actionsElements != null && actionsElementsSize > 0) {
            if (actionsElementsSize != 1) {
                throw new UnrecoverableException(this.getClass().getName(), (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (LocalizableMessage)new Message("AAA_REQ_E_MULTIPLE_REQUESTS_FOUND"));
            }
            Element actionElement = (Element)this.actionsElements.get(0);
            if (actionElement != null) {
                action = actionElement.getText();
            }
        }
        return action;
    }

    @Override
    public Credential getCredential(String theNamespaceID) {
        String credentialNS;
        Node node = null;
        String endOfXpath = "']]";
        if (this.decodedCredentials != null) {
            node = this.extractNSParentNodeFromDecodedCredentials(theNamespaceID, "']]");
        } else if (this.credential != null && (credentialNS = DocumentHelper.valueOf((String)NAMESPACE, (Node)this.credential)) != null && credentialNS.equals(theNamespaceID)) {
            node = this.credential;
        }
        return this.getCredential(node);
    }

    private Credential getCredential(Node node) {
        if (node != null && node.getNodeType() == 1) {
            return new CredentialImpl((Element)node);
        }
        return null;
    }

    @Override
    public Credential[] getCredentials() {
        Credential[] retval = null;
        if (this.decodedCredentials != null) {
            List list = this.decodedCredentials.elements();
            if (list != null && list.size() > 0) {
                retval = new Credential[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    retval[i] = this.getCredential((Node)list.get(i));
                }
            }
        } else if (this.credential != null) {
            retval = new Credential[]{this.getCredential((Node)this.credential)};
        }
        return retval;
    }

    @Override
    public String getNamespaceID() {
        String namespace = null;
        String[] namespaces = this.getFormFieldValues("CAMNamespace");
        if (namespaces != null && namespaces.length > 0) {
            namespace = namespaces[0];
        }
        String namespaceXPath = "//*/namespace/text()";
        if (namespace == null && this.credential != null) {
            namespace = DocumentHelper.valueOf((String)"//*/namespace/text()", (Node)this.credential);
        }
        if (namespace == null && this.decodedCredentials != null) {
            namespace = DocumentHelper.valueOf((String)"//*/namespace/text()", (Node)this.decodedCredentials);
        }
        return namespace;
    }

    @Override
    public Credential getTrustedCredential() {
        return null;
    }

    @Override
    public void removeNonPropagatableResponseElements() {
        Element additonalInfo;
        super.removeNonPropagatableResponseElements();
        Element biBusHeader = super.getBiBusHeaderElement();
        Element camSection = biBusHeader.element(CAM);
        if (camSection != null) {
            Iterator it = camSection.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String name = element.getName();
                if (!TO_REMOVE_FROM_CAM.contains(name)) continue;
                element.detach();
            }
        }
        if ((additonalInfo = biBusHeader.element("additionalInfo")) != null) {
            additonalInfo.detach();
        }
    }

    @Override
    public void setCredential(String camCredential) {
        Element biBusHeader = super.getBiBusHeaderElement();
        Element cam = (Element)DocumentHelper.selectSingleNode((XPath)XPATH_CAM, (Node)biBusHeader);
        Element credentialElement = (Element)DocumentHelper.selectSingleNode((String)"./*[local-name()='CAMCredential']", (Node)cam);
        if (credentialElement == null) {
            credentialElement = cam.addElement(CAM_CREDENTIAL);
            credentialElement.addAttribute(BiBusHeaderImpl.XSI_TYPE_NS, XSD_ANYTYPE);
        }
        credentialElement.setText(camCredential);
    }

    @Override
    public void setTrustedCredential(String camTrustedCredential) {
        Element biBusHeader = super.getBiBusHeaderElement();
        Element cam = (Element)DocumentHelper.selectSingleNode((XPath)XPATH_CAM, (Node)biBusHeader);
        Element trustedCredential = (Element)DocumentHelper.selectSingleNode((XPath)CAMTRUSTED_CREDENTIAL_XPATH, (Node)cam);
        if (trustedCredential == null) {
            trustedCredential = cam.addElement(CAM_TRUSTED_CREDENTIAL);
            trustedCredential.addAttribute(BiBusHeaderImpl.XSI_TYPE_NS, XSD_ANYTYPE);
        }
        trustedCredential.setText(camTrustedCredential);
    }
}

