/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.legacy.soap.HdrLogonRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HdrLogonTCRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderClonePassportRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderGenerateTCRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderLogoffRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderRetrieveCredentialRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderSelectRolesRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderValidateRequestImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.HeaderValidateWithResponseRequestImpl;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public final class LegacyHeaderRequest
implements SoapBody {
    private static final XPath SOAP_HEADER_XPATH = DocumentHelper.createXPath((String)"./SOAP-ENV:Header");
    private static final XPath TC_XPATH = DocumentHelper.createXPath((String)"./bus:biBusHeader/*[local-name()='CAM']/*[local-name()='CAMTrustedCredential']");
    private static final XPath ACTION_XPATH = DocumentHelper.createXPath((String)"./bus:biBusHeader/*[local-name()='CAM']/*[local-name()='action']");
    private static final String ACTION_LOGOFF = "logoff";
    private static final String ACTION_LOGON = "logon";
    private static final String ACTION_LOGON_AS = "logonAs";
    private static final String ACTION_VALIDATE = "validate";
    private static final String ACTION_VALIDATE_WITH_RESPONSE = "validateWithResponse";
    private static final String ACTION_GENERATE_TC = "generateTC";
    private static final String ACTION_GENERATE_CREDENTIAL = "generateCredential";
    private static final String ACTION_CLONE_PASSPORT = "clonePassport";
    private static final String ACTION_SELECT_ROLES = "selectRole";
    private SoapBodyEntry bodyEntry;

    private LegacyHeaderRequest(Element theSoapEnvelope, int requestType) throws SoapFaultException {
        Element soapHeader = (Element)DocumentHelper.selectSingleNode((XPath)SOAP_HEADER_XPATH, (Node)theSoapEnvelope);
        Element actionElement = DocumentHelper.selectSingleElement((XPath)ACTION_XPATH, (Node)soapHeader);
        String action = null;
        if (actionElement != null) {
            action = actionElement.getText();
        }
        boolean tc = DocumentHelper.selectSingleNode((XPath)TC_XPATH, (Node)soapHeader) != null;
        switch (requestType) {
            case 2: {
                this.bodyEntry = new HdrLogonRequestImpl(soapHeader);
                if (actionElement == null) break;
                actionElement.setText(ACTION_LOGON);
                break;
            }
            case -1: {
                if (action == null || action.length() == 0) {
                    this.bodyEntry = new HeaderValidateRequestImpl(soapHeader);
                    break;
                }
                if (action.equals(ACTION_VALIDATE)) {
                    this.bodyEntry = new HeaderValidateRequestImpl(soapHeader);
                    break;
                }
                if (action.equals(ACTION_VALIDATE_WITH_RESPONSE)) {
                    this.bodyEntry = new HeaderValidateWithResponseRequestImpl(soapHeader);
                    break;
                }
                if (action.equals(ACTION_LOGON) || action.equals(ACTION_LOGON_AS) && !tc) {
                    this.bodyEntry = new HdrLogonRequestImpl(soapHeader);
                    break;
                }
                if (action.equals(ACTION_LOGOFF)) {
                    this.bodyEntry = new HeaderLogoffRequestImpl(soapHeader);
                    break;
                }
                if (action.endsWith(ACTION_GENERATE_CREDENTIAL)) {
                    this.bodyEntry = new HeaderRetrieveCredentialRequestImpl(soapHeader);
                    break;
                }
                if (action.endsWith(ACTION_GENERATE_TC)) {
                    this.bodyEntry = new HeaderGenerateTCRequestImpl(soapHeader);
                    break;
                }
                if (action.endsWith(ACTION_LOGON_AS) && tc) {
                    this.bodyEntry = new HdrLogonTCRequestImpl(soapHeader);
                    break;
                }
                if (action.endsWith(ACTION_CLONE_PASSPORT)) {
                    this.bodyEntry = new HeaderClonePassportRequestImpl(soapHeader);
                    break;
                }
                if (action.endsWith(ACTION_SELECT_ROLES)) {
                    this.bodyEntry = new HeaderSelectRolesRequestImpl(soapHeader);
                    break;
                }
                throw new UnrecoverableException(LegacyHeaderRequest.class.getName(), (LocalizableMessage)new Message("AAA_SYS_E_INTERNAL_ERROR"), (LocalizableMessage)new Message("AAA_AUT_VALUE_INVALID_FOR_ACTION", (Object[])new String[]{action}));
            }
            default: {
                throw new IllegalArgumentException("Request type not implemented");
            }
        }
    }

    public static SoapBody getSoapBody(Element theSoapEnvelope) throws SoapFaultException {
        return new LegacyHeaderRequest(theSoapEnvelope, -1);
    }

    static SoapBody getSoapBody(Element theSoapEnvelope, int theType) throws SoapFaultException {
        return new LegacyHeaderRequest(theSoapEnvelope, theType);
    }

    public SoapBodyEntry getBodyEntry() {
        return this.bodyEntry;
    }
}

