/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.util.LocaleUtil;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Node;

public class LegacyRequestContextImpl
implements RequestContext {
    private static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final String SERVER_LOCALE = "serverLocale";
    private final Locale contentLocale;
    private final Locale productLocale;
    private final Locale serverLocale;
    private final LogContextImpl logContext;

    public LegacyRequestContextImpl(Element theSoapEnvelope) {
        String serverLocaleString = null;
        try {
            serverLocaleString = cclConfig.getValue(SERVER_LOCALE, false);
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        this.serverLocale = LocaleUtil.createLocale((String)serverLocaleString, (Locale)Locale.getDefault());
        this.logContext = this.createLogContext(theSoapEnvelope);
        String productLocaleString = null;
        String contentLocaleString = null;
        contentLocaleString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='contentLocale']", (Node)theSoapEnvelope);
        productLocaleString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='productLocale']", (Node)theSoapEnvelope);
        if (contentLocaleString == null) {
            contentLocaleString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='contentLocale']/../*[local-name()='value']", (Node)theSoapEnvelope);
        }
        if (productLocaleString == null) {
            productLocaleString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='userPreferenceVars']/*/*[local-name()='name'][camaaa:element-text(.)='productLocale']/../*[local-name()='value']", (Node)theSoapEnvelope);
        }
        this.contentLocale = LocaleUtil.createContentLocale((String)contentLocaleString, (Locale)this.serverLocale);
        this.productLocale = LocaleUtil.createProductLocale((String)productLocaleString, (Locale)this.serverLocale);
    }

    private LogContextImpl createLogContext(Element theSoapEnvelope) {
        String sessionID = null;
        String requestID = null;
        String subRequestIDString = null;
        Integer subRequestID = null;
        String stepID = null;
        if (theSoapEnvelope != null) {
            if (DocumentHelper.selectSingleElement((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']", (Node)theSoapEnvelope) != null) {
                requestID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']/*[local-name()='requestContext']", (Node)theSoapEnvelope);
                sessionID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']/*[local-name()='sessionContext']", (Node)theSoapEnvelope);
                stepID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']/*[local-name()='stepContext']", (Node)theSoapEnvelope);
                subRequestIDString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']/*[local-name()='hopCount']", (Node)theSoapEnvelope);
            } else {
                requestID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']/*[local-name()='requestContext']", (Node)theSoapEnvelope);
                sessionID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']/*[local-name()='sessionContext']", (Node)theSoapEnvelope);
                stepID = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']/*[local-name()='conversationContext']/*[local-name()='id']", (Node)theSoapEnvelope);
                subRequestIDString = DocumentHelper.valueOf((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='tracking']/*[local-name()='hopCount']", (Node)theSoapEnvelope);
            }
        }
        try {
            subRequestID = Integer.valueOf(subRequestIDString);
        }
        catch (NumberFormatException e) {
            subRequestID = null;
        }
        return new LogContextImpl(sessionID, requestID, subRequestID, stepID);
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public LogContext getLogContext() {
        return this.logContext;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public Locale getServerLocale() {
        return this.serverLocale;
    }
}

