/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyAdminBodyRequest;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyBiBusHeaderFactoryImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyHeaderRequest;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import org.dom4j.Element;

public class LegacySoapEnvelopeRequestImpl
extends SoapEnvRequestImpl {
    private static final String SOAP_BODY = "soap body";
    private static final String REQUEST = "request";
    private SoapBody body;
    private final Element soapEnvelope;

    public LegacySoapEnvelopeRequestImpl(Element theSoapEnvelope) throws SoapFaultException {
        super.init(theSoapEnvelope, new LegacyBiBusHeaderFactoryImpl());
        this.body = null;
        this.soapEnvelope = theSoapEnvelope;
        if (theSoapEnvelope.getQName().equals((Object)XMLConstants.SOAPENV_ENVELOPE)) {
            this.body = LegacyAdminBodyRequest.getSoapBody(theSoapEnvelope);
            if (this.body == null) {
                this.body = LegacyHeaderRequest.getSoapBody(theSoapEnvelope);
            }
            if (this.body == null) {
                Message msg = new Message("AAA_REQ_E_MISSING_REQUIRED_ELEMENT", new Object[]{new String(REQUEST), new String(SOAP_BODY)});
                throw new UnrecoverableException("Client", (LocalizableMessage)msg, (LocalizableMessage)msg);
            }
        }
    }

    public LegacySoapEnvelopeRequestImpl(LegacySoapEnvelopeRequestImpl template, int newType) throws SoapFaultException {
        this.soapEnvelope = template.soapEnvelope.createCopy();
        super.init(this.soapEnvelope, new LegacyBiBusHeaderFactoryImpl());
        int requestType = template.getBody().getBodyEntry().getType();
        if (!LegacySoapEnvelopeRequestImpl.shouldTransformToLogonRequest(requestType)) {
            throw new IllegalArgumentException("This request" + requestType + "is not supported as templates.");
        }
        this.body = LegacyHeaderRequest.getSoapBody(this.soapEnvelope, newType);
        if (this.body == null) {
            Message msg = new Message("AAA_REQ_E_MISSING_REQUIRED_ELEMENT", new Object[]{new String(REQUEST), new String(SOAP_BODY)});
            throw new UnrecoverableException("Client", (LocalizableMessage)msg, (LocalizableMessage)msg);
        }
    }

    public SoapBody getBody() {
        return this.body;
    }

    @Override
    public Element getElement() {
        return this.soapEnvelope;
    }

    public static boolean shouldTransformToLogonRequest(int requestType) {
        return requestType == 3 || requestType == 5 || requestType == 20 || requestType == 24 || requestType == 30;
    }
}

