/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.legacy.soap;

import com.ibm.cognos.camaaa.internal.common.exception.HeaderFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.service.XMLSerializer;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBody;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyAdminBodyResponse;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyBiBusHeaderFactoryImpl;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacyHeaderResponse;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class LegacySoapEnvelopeResponseImpl
extends SoapEnvResponseImpl {
    private SoapBodyResponse bodyResponse = null;
    private Element soapEnvelope = null;
    private Element soapEnvBody = null;
    private SoapFault soapFault = null;

    public LegacySoapEnvelopeResponseImpl(Element theSoapEnvelope, RequestContext theRequestContext) {
        if (theSoapEnvelope.getQName().equals((Object)XMLConstants.SOAPENV_ENVELOPE)) {
            this.soapEnvelope = DocumentHelper.createDocument().addElement(XMLConstants.SOAPENV_ENVELOPE);
            Element originalHdrElement = theSoapEnvelope.element(XMLConstants.SOAPENV_HEADER);
            if (originalHdrElement != null) {
                this.soapEnvelope.add(originalHdrElement.createCopy());
            }
            super.init(this.soapEnvelope, new LegacyBiBusHeaderFactoryImpl());
            SoapHeader soapHdr = this.getHeader();
            BiBusHeader bbHdr = null;
            if (soapHdr != null) {
                bbHdr = soapHdr.getBiBusHeader();
            }
            if (bbHdr != null) {
                bbHdr.removeNonPropagatableResponseElements();
            }
            Element soapQuery = null;
            Element soapBody = theSoapEnvelope.element(XMLConstants.SOAPENV_BODY);
            if (soapBody != null) {
                soapQuery = soapBody.element("query");
            }
            this.bodyResponse = soapQuery == null ? new LegacyHeaderResponse(theRequestContext) : (LegacyAdminBodyResponse)LegacyAdminBodyResponse.getSoapBody(theSoapEnvelope, theRequestContext);
        }
    }

    public SoapBody getBody() {
        return this.bodyResponse;
    }

    @Override
    public Element getElement() {
        if (this.soapEnvBody != null) {
            this.soapEnvelope.remove(this.soapEnvBody);
        }
        this.soapEnvBody = this.bodyResponse.getElement();
        this.soapEnvelope.add(this.soapEnvBody);
        return this.soapEnvelope;
    }

    @Override
    public SoapFault getFaultEntry() {
        return this.soapFault;
    }

    @Override
    public void setFaultEntry(SoapFault theSoapFault, MessageContext messageContext) {
        this.bodyResponse.setFaultBodyEntry((SoapFault)new HeaderFaultException(theSoapFault));
        this.soapFault = theSoapFault;
        Element hdrElement = null;
        Element bibusElement = null;
        Element camElement = null;
        hdrElement = this.soapEnvelope.element(XMLConstants.SOAPENV_HEADER);
        if (hdrElement != null) {
            bibusElement = hdrElement.element(XMLConstants.BIBUS_BIBUSHEADER);
        }
        if (bibusElement != null) {
            camElement = bibusElement.element(XMLConstants.BIBUS_CAM.getName());
        }
        RequestContext requestContext = (RequestContext)messageContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        if (camElement != null) {
            Element exceptionElement = XMLSerializer.serializeException(theSoapFault, requestContext);
            String xpathForException = "./*[local-name()='" + exceptionElement.getName() + "']";
            com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.removeMatchedNodes((Element)camElement, (String[])new String[]{xpathForException});
            camElement.add(exceptionElement);
        }
    }
}

