/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.AbstractSimpleMultiplePath;
import com.ibm.cognos.camaaa.internal.multitenacy.AncestorsPath;
import com.ibm.cognos.camaaa.internal.multitenacy.ParametersPath;
import com.ibm.cognos.camaaa.internal.multitenacy.Path;
import com.ibm.cognos.camaaa.internal.multitenacy.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class BaseClassPathFactory {
    private static final HashMap<String, PathFactory> MAP = new HashMap();

    private BaseClassPathFactory() {
    }

    private static Path createAncestorPath(int index, List<Property> theProperties) throws LocalizableException {
        Path path = BaseClassPathFactory.createPath(theProperties);
        return new AncestorsPath(path, index);
    }

    private static Path createDefaultNamePath() {
        return new AbstractSimpleMultiplePath(){

            @Override
            public String execute(Object obj, RequestContext requestContext) {
                BaseClass baseClass = (BaseClass)obj;
                return baseClass.getDefaultName(requestContext);
            }
        };
    }

    private static Path createNamePath(Property property) {
        final Locale locale = property == null ? Locale.getDefault() : new Locale(property.getProperty());
        return new AbstractSimpleMultiplePath(){

            @Override
            public String execute(Object obj, RequestContext requestContext) {
                BaseClass baseClass = (BaseClass)obj;
                return baseClass.getName(locale);
            }
        };
    }

    private static Path createObjectIdPath() {
        return new AbstractSimpleMultiplePath(){

            @Override
            public String execute(Object obj, RequestContext requestContext) {
                SearchPath searchPath = (SearchPath)obj;
                return searchPath.getObjectID();
            }
        };
    }

    private static Path createParametersPath(Property property) {
        if (property.hasIndex()) {
            return new ParametersPath(property.getProperty(), property.getIndex());
        }
        return new ParametersPath(property.getProperty());
    }

    public static Path createPath(List<Property> properties) throws LocalizableException {
        if (properties == null || properties.size() == 0) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_NO_PROPERTY"));
        }
        Property property = properties.remove(0);
        String propertyString = property.getProperty();
        PathFactory factory = MAP.get(propertyString);
        if (factory == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_UNRECONIZED_PROPERTY", (Object[])new String[]{propertyString}));
        }
        return factory.createpath(property, properties);
    }

    private static Path createSearchPathPath(List<Property> theProperties) throws LocalizableException {
        final Path path = BaseClassPathFactory.createPath(theProperties);
        return new AbstractSimpleMultiplePath(){

            @Override
            public String execute(Object obj, RequestContext requestContext) {
                BaseClass baseClass = (BaseClass)obj;
                SearchPath searchPath = baseClass.getSearchPath();
                return path.execute(searchPath, requestContext);
            }
        };
    }

    static {
        MAP.put("ancestors", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) throws LocalizableException {
                return BaseClassPathFactory.createAncestorPath(property.getIndex(), properties);
            }
        });
        MAP.put("parameters", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) throws LocalizableException {
                if (properties.size() == 0) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_EXPECTED_PROPERTY_PARAMETERS"));
                }
                Property parametersProperty = properties.remove(0);
                return BaseClassPathFactory.createParametersPath(parametersProperty);
            }
        });
        MAP.put("searchPath", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) throws LocalizableException {
                return BaseClassPathFactory.createSearchPathPath(properties);
            }
        });
        MAP.put("name", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) {
                if (properties.size() == 0) {
                    return BaseClassPathFactory.createNamePath(null);
                }
                return BaseClassPathFactory.createNamePath(properties.remove(0));
            }
        });
        MAP.put("defaultName", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) {
                return BaseClassPathFactory.createDefaultNamePath();
            }
        });
        MAP.put("objectId", new PathFactory(){

            @Override
            public Path createpath(Property property, List<Property> properties) {
                return BaseClassPathFactory.createObjectIdPath();
            }
        });
    }

    private static interface PathFactory {
        public Path createpath(Property var1, List<Property> var2) throws LocalizableException;
    }
}

