/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.cognos.CAM_AAA.authentication.IProvider;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLogger;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.util.CustomProviderProxyAdapter;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.UnrecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.InitableDestroyable;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class CustomResolver<T extends IProvider>
implements InitableDestroyable {
    private T provider;
    private PerfLogger perfLogger;
    private STATES state = STATES.UNINIT;

    CustomResolver(T theProvider, PerfLogger thePerfLogger) {
        this.provider = theProvider;
        this.perfLogger = thePerfLogger;
    }

    protected T getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> S callWithProtectedClassLoader(String methodName, CustomResolverCallable<S> callable, LogContext logContext) throws com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException {
        S s;
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Object indication = null;
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            indication = this.logEnter(methodName, logContext);
            s = callable.call();
            if (indication != null) {
                this.logExit(indication);
            }
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
        catch (Throwable throwable) {
            if (indication != null) {
                this.logExit(indication);
            }
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
            throw throwable;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Map<String, String> advancedConfigurations, String namespaceId) throws LocalizableException {
        STATES sTATES = this.state;
        synchronized (sTATES) {
            if (this.state == STATES.INIT) {
                return;
            }
            this.state = STATES.INIT;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Object indication = null;
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            indication = this.logEnter("init", new LogContextImpl(null, null, 0, null));
            this.provider.init(advancedConfigurations, namespaceId);
            if (indication != null) {
                this.logExit(indication);
            }
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
        catch (UnrecoverableException e) {
            try {
                try {
                    throw UnrecoverableExceptionConverter.convertException(e);
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (indication != null) {
                    this.logExit(indication);
                }
                Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        STATES sTATES = this.state;
        synchronized (sTATES) {
            if (this.state == STATES.DESTROY) {
                return;
            }
            this.state = STATES.DESTROY;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        Object indication = null;
        try {
            Thread.currentThread().setContextClassLoader(CustomProviderProxyAdapter.getProviderClassLoader());
            indication = this.logEnter("destroy", new LogContextImpl(null, null, 0, null));
            this.provider.destroy();
            if (indication != null) {
                this.logExit(indication);
            }
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
        }
        catch (Throwable throwable) {
            if (indication != null) {
                this.logExit(indication);
            }
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader);
            throw throwable;
        }
    }

    protected Object logEnter(String method, LogContext logContext) {
        Object indication = null;
        if (this.perfLogger.isEnabled(Logger.LEVEL2)) {
            LogData logData = this.perfLogger.getLogData();
            indication = this.perfLogger.logEnter(logContext, ComponentImpl.getInstance(), Logger.LEVEL2, this.provider.getClass().getName(), method, "sequenceID", logData);
        }
        return indication;
    }

    protected void logExit(Object indication) {
        LogData logData = this.perfLogger.getLogData();
        this.perfLogger.logExit(indication, logData);
    }

    protected static PerfLogger createPerfLogger(String loggerName) {
        LogTypedLogger perflogger = LogTypedLogger.getInstance((String)loggerName, LogPerfIndication.class);
        return new PerfLoggerImpl(perflogger);
    }

    protected static <T extends IProvider> T loadCustomProvider(Class<T> clazz, String className) throws LocalizableException {
        try {
            Class<?> c = Class.forName(className, true, CustomProviderProxyAdapter.getProviderClassLoader());
            if (clazz.isAssignableFrom(c)) {
                Object instance = c.newInstance();
                return (T)((IProvider)clazz.cast(instance));
            }
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_IPROVIDER_CLASS_LOAD_ERROR", new Object[]{clazz.getSimpleName(), className}));
        }
        catch (ClassNotFoundException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_IPROVIDER_CLASS_LOAD_ERROR", new Object[]{clazz.getSimpleName(), className}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_IPROVIDER_CLASS_LOAD_ERROR", new Object[]{clazz.getSimpleName(), className}), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_IPROVIDER_CLASS_LOAD_ERROR", new Object[]{clazz.getSimpleName(), className}), (Throwable)e);
        }
    }

    private static enum STATES {
        UNINIT,
        INIT,
        DESTROY;

    }

    protected static interface CustomResolverCallable<S>
    extends Callable<S> {
        @Override
        public S call() throws com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
    }
}

