/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.cognos.CAM_AAA.authentication.IAccount;
import com.cognos.CAM_AAA.authentication.ITenantProvider;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLogger;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.customLegacy.exception.UnrecoverableExceptionConverter;
import com.ibm.cognos.camaaa.internal.multitenacy.CustomResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.TenantIDResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.adapters.AccountAdapter;

public class CustomTenantResolver
extends CustomResolver<ITenantProvider>
implements TenantIDResolver {
    CustomTenantResolver(ITenantProvider theITenantProvider, PerfLogger thePerfLogger) {
        super(theITenantProvider, thePerfLogger);
    }

    public CustomTenantResolver(String className) throws LocalizableException {
        super(CustomResolver.loadCustomProvider(ITenantProvider.class, className), CustomResolver.createPerfLogger("Perf.CAM.AAA.SRVC.ITenantProvider"));
    }

    @Override
    public String resolveTenant(final Account theAccount, RequestContext theRequestContext) throws com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException {
        return this.callWithProtectedClassLoader("getTenantId", new CustomResolver.CustomResolverCallable<String>(){

            @Override
            public String call() throws com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException {
                try {
                    AccountAdapter account = new AccountAdapter(theAccount);
                    String tenantId = ((ITenantProvider)CustomTenantResolver.this.getProvider()).getTenantId((IAccount)account);
                    if (tenantId == null) {
                        return "";
                    }
                    return tenantId;
                }
                catch (UnrecoverableException e) {
                    throw UnrecoverableExceptionConverter.convertException(e);
                }
            }
        }, theRequestContext.getLogContext());
    }
}

