/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationUtils;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyAdvancedProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MultitenancyConfiguration {
    public static final String PUBLIC_TENANT_ID = "";
    public static final String TENANCY_INFO = "tenantIdMapping";
    public static final String BOUNDING_SET_INFO = "tenantBoundingSetMapping";
    public static final String PATTERN = "pattern";
    public static final String PROVIDER_CLASS = "providerClass";
    public static final String TENANT_PROVIDER = "multitenancy.ITenantProvider";
    public static final String TENANT_PATTERN = "multitenancy.TenantPattern";
    public static final String BOUNDING_SET_PATTERN = "multitenancy.BoundingSetPattern";
    public static final String BOUNDING_SET_PROVIDER = "multitenancy.IBoundingSetProvider";
    private static final String CONFIG_PARAMETER_XPATH_PREFIX = "./*[local-name()='parameter'][@name=\"";
    private static final String CONFIG_PARAMETER_XPATH_MID = "\"]/*[local-name()='value']/*[local-name()='item'][@name=\"";
    private static final String CONFIG_PARAMETER_XPATH_SUFFIX = "\"]/text()";
    private static final String COGNOS_NS = "Cognos";
    private HashMap<String, MultitenancyAdvancedProperties.AdvancedProperty> tenancyProperties;
    private HashMap<String, MultitenancyAdvancedProperties.AdvancedProperty> boundingSetProperties;

    public MultitenancyConfiguration(Configuration config) throws LocalizableException {
        this.parse(config);
    }

    private static void addBoundingSetProp(Configuration config, String nsId, HashMap<String, MultitenancyAdvancedProperties.AdvancedProperty> advProperties) throws LocalizableException {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = MultitenancyConfiguration.getBoundingSetProp(config);
        if (advProp != null) {
            advProperties.put(nsId, advProp);
        }
    }

    private static void addTenancyProp(Configuration config, String nsId, HashMap<String, MultitenancyAdvancedProperties.AdvancedProperty> advProperties) {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = MultitenancyConfiguration.getTenancyProp(config);
        if (advProp != null) {
            advProperties.put(nsId, advProp);
        }
    }

    private static MultitenancyAdvancedProperties.AdvancedProperty getBoundingSetProp(Configuration config) throws LocalizableException {
        MultitenancyAdvancedProperties.AdvancedProperty ret = null;
        String boundingSetPattern = config.getOptionalValue(MultitenancyConfiguration.getParameterXpath(BOUNDING_SET_INFO, PATTERN), null);
        String iBoundingSetProvider = config.getOptionalValue(MultitenancyConfiguration.getParameterXpath(BOUNDING_SET_INFO, PROVIDER_CLASS), null);
        if (boundingSetPattern != null && iBoundingSetProvider != null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_E_CANNOT_DEFINE_PATTERN_AND_PROVIDER"));
        }
        if (boundingSetPattern != null) {
            ret = MultitenancyAdvancedProperties.createBoundingSetPattern(boundingSetPattern);
        } else if (iBoundingSetProvider != null) {
            ret = MultitenancyAdvancedProperties.createBoundingSetProvider(iBoundingSetProvider, config);
        }
        return ret;
    }

    private static MultitenancyAdvancedProperties.AdvancedProperty getTenancyProp(Configuration config) {
        String tenantProvider;
        String tenantPattern = config.getOptionalValue(MultitenancyConfiguration.getParameterXpath(TENANCY_INFO, PATTERN), null);
        MultitenancyAdvancedProperties.AdvancedProperty ret = tenantPattern != null ? MultitenancyAdvancedProperties.createTenantPattern(tenantPattern) : ((tenantProvider = config.getOptionalValue(MultitenancyConfiguration.getParameterXpath(TENANCY_INFO, PROVIDER_CLASS), null)) != null ? MultitenancyAdvancedProperties.createTenantProvider(tenantProvider, config) : null);
        return ret;
    }

    public static String getParameterXpath(String paramName, String paramType) {
        return CONFIG_PARAMETER_XPATH_PREFIX + paramName + CONFIG_PARAMETER_XPATH_MID + paramType + CONFIG_PARAMETER_XPATH_SUFFIX;
    }

    public MultitenancyAdvancedProperties.AdvancedProperty getBoundingSetProperty(String theNamespaceID) {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = this.boundingSetProperties.get(theNamespaceID);
        if (advProp == null) {
            advProp = this.boundingSetProperties.get(null);
        }
        return advProp;
    }

    public MultitenancyAdvancedProperties.AdvancedProperty getBoundingSetPropertyNS(String theNamespaceID) {
        return this.boundingSetProperties.get(theNamespaceID);
    }

    public Set<String> getNamespacesWithTenancyProps() {
        HashSet<String> result = new HashSet<String>(this.tenancyProperties.keySet());
        result.addAll(this.boundingSetProperties.keySet());
        return result;
    }

    public MultitenancyAdvancedProperties.AdvancedProperty getTenancyProperty(String theNamespaceID) {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = this.tenancyProperties.get(theNamespaceID);
        if (advProp == null) {
            return this.tenancyProperties.get(null);
        }
        return advProp;
    }

    public MultitenancyAdvancedProperties.AdvancedProperty getTenancyPropertyNS(String theNamespaceID) {
        return this.tenancyProperties.get(theNamespaceID);
    }

    public boolean isMultitenancyEnabled() {
        return !this.tenancyProperties.isEmpty() || !this.boundingSetProperties.isEmpty();
    }

    private void parse(Configuration config) throws LocalizableException {
        this.tenancyProperties = new HashMap();
        this.boundingSetProperties = new HashMap();
        MultitenancyConfiguration.addTenancyProp(config, null, this.tenancyProperties);
        MultitenancyConfiguration.addBoundingSetProp(config, null, this.boundingSetProperties);
        Configuration[] namespaceConfigs = ConfigurationUtils.getNamespaceConfigs(config);
        if (namespaceConfigs != null) {
            for (int i = 0; i < namespaceConfigs.length; ++i) {
                Configuration nsConfig = namespaceConfigs[i];
                String type = ConfigurationUtils.getNamespaceType(nsConfig);
                if (COGNOS_NS.equals(type)) continue;
                String nsId = ConfigurationUtils.getNamespaceID(nsConfig);
                MultitenancyConfiguration.addTenancyProp(nsConfig, nsId, this.tenancyProperties);
                MultitenancyConfiguration.addBoundingSetProp(nsConfig, nsId, this.boundingSetProperties);
            }
        }
    }
}

