/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.BaseClassPathFactory;
import com.ibm.cognos.camaaa.internal.multitenacy.Path;
import com.ibm.cognos.camaaa.internal.multitenacy.Property;
import com.ibm.cognos.camaaa.internal.xpath.SearchExpressionParser;
import com.ibm.cognos.camaaa.internal.xpath.Token;
import java.util.ArrayList;
import java.util.List;

public class PathFinder {
    private final Path path;
    private final String defaultPath;

    public PathFinder(SearchExpressionParser theParser) throws LocalizableException {
        this(theParser, null);
    }

    public PathFinder(SearchExpressionParser theParser, String theDefaultPath) throws LocalizableException {
        List<Property> props = PathFinder.parsePath(theParser);
        this.defaultPath = theDefaultPath;
        this.path = BaseClassPathFactory.createPath(props);
    }

    private static int parseFilter(SearchExpressionParser theParser) throws LocalizableException {
        int index = 0;
        Token token = theParser.getNextToken();
        if (token.kind != 21) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_EXPECTED_NUMBER", (Object[])new String[]{token.image}));
        }
        try {
            index = Integer.parseInt(token.image);
        }
        catch (NumberFormatException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_EXPECTED_NUMBER", (Object[])new String[]{token.image}), (Throwable)e);
        }
        Token rightSQBR = theParser.getNextToken();
        if (39 != rightSQBR.kind) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_EXPECTED_RDQBR", (Object[])new String[]{rightSQBR.image}));
        }
        return index;
    }

    private static List<Property> parsePath(SearchExpressionParser theParser) throws LocalizableException {
        while (true) {
            ArrayList<Property> props = new ArrayList<Property>();
            Token token = theParser.getNextToken();
            switch (token.kind) {
                case 0: {
                    return props;
                }
                case 32: {
                    PathFinder.parseProperty(theParser, props);
                    return props;
                }
            }
        }
    }

    private static void parseProperty(SearchExpressionParser theParser, ArrayList<Property> props) throws LocalizableException {
        Token token = theParser.getNextToken();
        if (token.kind != 21) {
            if (token.image == null || token.image.length() == 0) {
                throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_NO_PROPERTY"));
            }
            throw new LocalizableException((LocalizableMessage)new Message("AAA_AUT_MT_EXPECTED_PROPERTY", (Object[])new String[]{token.image}));
        }
        String name = token.image;
        Integer index = null;
        block5: while (true) {
            token = theParser.getNextToken();
            switch (token.kind) {
                case 0: {
                    props.add(new Property(name, index));
                    return;
                }
                case 38: {
                    index = new Integer(PathFinder.parseFilter(theParser));
                    continue block5;
                }
                case 32: {
                    props.add(new Property(name, index));
                    PathFinder.parseProperty(theParser, props);
                    return;
                }
            }
        }
    }

    public String find(Account account, RequestContext requestContext) {
        String foundPath = this.path.execute(account, requestContext);
        if (foundPath == null) {
            return this.defaultPath;
        }
        return foundPath;
    }

    public String[] findMultiple(Account account, RequestContext requestContext) {
        return this.path.executeMultiple(account, requestContext);
    }
}

