/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.multitenacy.BoundingSetResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.TenantIDResolver;

public class TenancyResolver {
    private final TenancyResolver parent;
    private final BoundingSetResolver boundingSetResolver;
    private final TenantIDResolver tenantIdResolver;

    public TenancyResolver(TenancyResolver theParent, TenantIDResolver theTenantIdResolver, BoundingSetResolver theBoundingSetResolver) {
        this.parent = theParent == null ? new NullTenancyResolver() : theParent;
        this.tenantIdResolver = theTenantIdResolver;
        this.boundingSetResolver = theBoundingSetResolver;
    }

    private TenancyResolver() {
        this.parent = null;
        this.tenantIdResolver = null;
        this.boundingSetResolver = null;
    }

    public boolean canResolveBoundingSet() {
        return this.hasBoundingSetResolver() || this.parent.canResolveBoundingSet();
    }

    private boolean hasBoundingSetResolver() {
        return this.boundingSetResolver != null;
    }

    public boolean canResolveTenantId() {
        return this.hasTenantIdResolver() || this.parent.canResolveTenantId();
    }

    private boolean hasTenantIdResolver() {
        return this.tenantIdResolver != null;
    }

    public String[] resolveBoundingSet(Account theAccount, RequestContext theRequestContext) throws UnrecoverableException {
        String[] result = null;
        if (this.hasBoundingSetResolver()) {
            result = this.boundingSetResolver.resolveBoundingSet(theAccount, theRequestContext);
        } else if (this.parent.canResolveBoundingSet()) {
            result = this.parent.resolveBoundingSet(theAccount, theRequestContext);
        }
        return result;
    }

    public String resolveTenantId(Account theAccount, RequestContext theRequestContext) throws UnrecoverableException {
        String result = null;
        if (this.hasTenantIdResolver()) {
            result = this.tenantIdResolver.resolveTenant(theAccount, theRequestContext);
        } else if (this.parent.canResolveTenantId()) {
            result = this.parent.resolveTenantId(theAccount, theRequestContext);
        }
        return result;
    }

    public void destroy() {
        if (this.tenantIdResolver != null) {
            this.tenantIdResolver.destroy();
        }
        if (this.boundingSetResolver != null) {
            this.boundingSetResolver.destroy();
        }
    }

    public static final class NullTenancyResolver
    extends TenancyResolver {
        @Override
        public boolean canResolveBoundingSet() {
            return false;
        }

        @Override
        public boolean canResolveTenantId() {
            return false;
        }
    }
}

