/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy;

import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.BoundingSetResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.CustomBoundingSetResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.CustomTenantResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyAdvancedProperties;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyConfiguration;
import com.ibm.cognos.camaaa.internal.multitenacy.PathBoundingSetResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.PathTenantResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.TenancyResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.TenancyResolverFactory;
import com.ibm.cognos.camaaa.internal.multitenacy.TenantIDResolver;

public class TenancyResolverFactoryImpl
implements TenancyResolverFactory {
    private final MultitenancyConfiguration mtConfig;
    private final TenancyResolver rootResolver;

    public TenancyResolverFactoryImpl(MultitenancyConfiguration theMTConfig) throws LocalizableException {
        this.mtConfig = theMTConfig;
        this.rootResolver = this.createTenancyResolver(null);
    }

    public TenancyResolverFactoryImpl(MultitenancyConfiguration theMTConfig, TenancyResolver theRootResolver) {
        this.mtConfig = theMTConfig;
        this.rootResolver = theRootResolver;
    }

    @Override
    public TenancyResolver createTenancyResolver(String namespaceId) throws LocalizableException {
        if (namespaceId == null && this.rootResolver != null) {
            return this.rootResolver;
        }
        TenancyResolver parent = namespaceId == null ? null : this.rootResolver;
        TenantIDResolver tenantIdResolver = this.createTenantIdResolver(namespaceId);
        BoundingSetResolver boundingSetResolver = this.createBoundingSetResolver(namespaceId);
        return new TenancyResolver(parent, tenantIdResolver, boundingSetResolver);
    }

    protected TenantIDResolver createTenantIdResolver(String namespaceId) throws LocalizableException {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = this.mtConfig.getTenancyPropertyNS(namespaceId);
        if (advProp != null) {
            try {
                TenantIDResolver tr;
                if (advProp instanceof MultitenancyAdvancedProperties.TenantPattern) {
                    tr = this.createTenantResolver((MultitenancyAdvancedProperties.TenantPattern)advProp, namespaceId);
                } else if (advProp instanceof MultitenancyAdvancedProperties.TenantProvider) {
                    tr = this.createTenantResolver((MultitenancyAdvancedProperties.TenantProvider)advProp, namespaceId);
                } else {
                    throw new Exception(this.createUnimplementedAdvancedPropertyErrorString(advProp));
                }
                return tr;
            }
            catch (Throwable e) {
                if (namespaceId == null) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_CAP_E_READING_TENANT_ADV_PROPS", new Object[]{advProp.getName()}), e);
                }
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CAP_E_READING_TENANT_NS_ADV_PROPS", new Object[]{advProp.getName(), namespaceId}), e);
            }
        }
        return null;
    }

    protected BoundingSetResolver createBoundingSetResolver(String namespaceId) throws LocalizableException {
        MultitenancyAdvancedProperties.AdvancedProperty advProp = this.mtConfig.getBoundingSetPropertyNS(namespaceId);
        if (advProp != null) {
            try {
                BoundingSetResolver boundingSetResolver;
                if (advProp instanceof MultitenancyAdvancedProperties.BoundingSetPattern) {
                    boundingSetResolver = this.createBoundingSetResolver((MultitenancyAdvancedProperties.BoundingSetPattern)advProp, namespaceId);
                } else if (advProp instanceof MultitenancyAdvancedProperties.BoundingSetProvider) {
                    boundingSetResolver = this.createBoundingSetResolver((MultitenancyAdvancedProperties.BoundingSetProvider)advProp, namespaceId);
                } else {
                    throw new Exception(this.createUnimplementedAdvancedPropertyErrorString(advProp));
                }
                return boundingSetResolver;
            }
            catch (Throwable e) {
                if (namespaceId == null) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_CAP_E_READING_TENANT_ADV_PROPS", new Object[]{advProp.getName()}), e);
                }
                throw new LocalizableException((LocalizableMessage)new Message("AAA_CAP_E_READING_TENANT_NS_ADV_PROPS", new Object[]{advProp.getName(), namespaceId}), e);
            }
        }
        return null;
    }

    private String createUnimplementedAdvancedPropertyErrorString(MultitenancyAdvancedProperties.AdvancedProperty advProp) {
        return "Unimplemented multitenant advaced property, " + advProp.getName() + "!";
    }

    private CustomTenantResolver createTenantResolver(MultitenancyAdvancedProperties.TenantProvider advProp, String namespaceId) throws LocalizableException {
        String className = advProp.getValue();
        CustomTenantResolver tr = new CustomTenantResolver(className);
        tr.init(advProp.getAdvancedProperties(), namespaceId);
        return tr;
    }

    private PathTenantResolver createTenantResolver(MultitenancyAdvancedProperties.TenantPattern advProp, String namespaceId) throws LocalizableException {
        String path = advProp.getValue();
        PathTenantResolver tr = new PathTenantResolver(path);
        tr.init(null, namespaceId);
        return tr;
    }

    private CustomBoundingSetResolver createBoundingSetResolver(MultitenancyAdvancedProperties.BoundingSetProvider advProp, String namespaceId) throws LocalizableException {
        String className = advProp.getValue();
        CustomBoundingSetResolver tr = new CustomBoundingSetResolver(className);
        tr.init(advProp.getAdvancedProperties(), namespaceId);
        return tr;
    }

    private PathBoundingSetResolver createBoundingSetResolver(MultitenancyAdvancedProperties.BoundingSetPattern advProp, String namespaceId) throws LocalizableException {
        String path = advProp.getValue();
        PathBoundingSetResolver tr = new PathBoundingSetResolver(path);
        tr.init(null, namespaceId);
        return tr;
    }
}

