/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.adapters;

import com.cognos.CAM_AAA.authentication.IBaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceFolder;
import com.ibm.cognos.camaaa.internal.multitenacy.adapters.AccountAdapter;
import com.ibm.cognos.camaaa.internal.multitenacy.adapters.NamespaceAdapter;
import com.ibm.cognos.camaaa.internal.multitenacy.adapters.NamespaceFolderAdapter;
import java.util.Locale;

public class BaseClassAdapter
implements IBaseClass {
    private final BaseClass baseClass;

    public BaseClassAdapter(BaseClass theBaseClass) {
        this.baseClass = theBaseClass;
    }

    private BaseClassAdapter getAdapterFor(BaseClass theBaseClass) {
        BaseClassAdapter result;
        String objectClass = theBaseClass.getObjectClass();
        if ("account".equals(objectClass)) {
            result = new AccountAdapter((Account)theBaseClass);
        } else if ("namespace".equals(objectClass)) {
            result = new NamespaceAdapter((Namespace)theBaseClass);
        } else if ("namespaceFolder".equals(objectClass)) {
            result = new NamespaceFolderAdapter((NamespaceFolder)theBaseClass);
        } else if ("directory".equals(objectClass)) {
            result = new BaseClassAdapter(theBaseClass);
        } else {
            throw new IllegalArgumentException("Illegal objectClass '" + objectClass + "' provided as ancestor.");
        }
        return result;
    }

    public IBaseClass[] getAncestors() {
        BaseClass[] baseAncestors = this.baseClass.getAncestors();
        IBaseClass[] adaptedAncestors = new IBaseClass[baseAncestors.length];
        for (int i = 0; i < baseAncestors.length; ++i) {
            adaptedAncestors[i] = this.getAdapterFor(baseAncestors[i]);
        }
        return adaptedAncestors;
    }

    public Locale[] getAvailableNameLocales() {
        return this.baseClass.getAvailableNameLocales();
    }

    protected BaseClass getBaseObject() {
        return this.baseClass;
    }

    public boolean getHasChildren() {
        return this.baseClass.getHasChildren();
    }

    public String getName(Locale theLocale) {
        return this.baseClass.getName(theLocale);
    }

    public String getObjectID() {
        return this.baseClass.getSearchPath().getObjectID();
    }
}

