/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.Tenant;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AddTenancyToAccount
extends DefaultHandler {
    private static final String ACTOR = AddTenancyToAccount.class.getName();
    private final AuditLoggerImpl logger;
    private final Component component;
    private boolean cmIsDisabled;

    public AddTenancyToAccount() {
        LogTypedLogger typedLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
        this.logger = new AuditLoggerImpl(typedLogger);
        this.component = ComponentImpl.getInstance();
    }

    AddTenancyToAccount(AuditLoggerImpl auditLogger, Component theComponent) {
        this.logger = auditLogger;
        this.component = theComponent;
    }

    private static boolean isSystemAdministrator(MessageContext theContext) {
        boolean retval = false;
        Set logonRoles = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles");
        if (logonRoles != null) {
            retval = logonRoles.contains("CAMID(\"::System Administrators\")");
        }
        return retval;
    }

    private static boolean isTenantAdministrator(MessageContext theContext) {
        boolean retval = false;
        Set logonRoles = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles");
        if (logonRoles != null) {
            retval = logonRoles.contains("CAMID(\"::Tenant Administrators\")");
        }
        return retval;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean isSysAdmin = AddTenancyToAccount.isSystemAdministrator(theContext);
        BaseClass[] tenantsArray = (BaseClass[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.admin.handler.ExtractTenantInfo.TENANT_INFO");
        if (tenantsArray != null) {
            HashMap<String, Tenant> tenantsSet = new HashMap<String, Tenant>(tenantsArray.length);
            for (BaseClass tenant : tenantsArray) {
                tenantsSet.put(tenant.getTenantID(), (Tenant)tenant);
            }
            QueryResult userInfo = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
            BaseClass[] baseClasses = userInfo.getAll();
            Account account = (Account)baseClasses[0];
            if (account == null) {
                return false;
            }
            if (!this.cmIsDisabled) {
                boolean isTenantAdmin = AddTenancyToAccount.isTenantAdministrator(theContext);
                String tenantId = this.setTenantID(theContext, tenantsSet, account, isSysAdmin);
                this.setImpersonatedTenantID(theContext, tenantsSet, account, isSysAdmin, isTenantAdmin);
                this.setBoundingSet(theContext, tenantsSet, tenantId, account, isSysAdmin, isTenantAdmin);
            }
        }
        return true;
    }

    private void setBoundingSet(MessageContext theContext, Map<String, Tenant> theTenants, String tenantId, Account account, boolean isSysAdmin, boolean isTenantAdmin) {
        String[] boundingSetArray = (String[])theContext.remove((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds");
        if (isSysAdmin || boundingSetArray == null && isTenantAdmin) {
            return;
        }
        if (boundingSetArray == null) {
            boundingSetArray = new String[]{};
        }
        HashSet<String> boundingSet = new HashSet<String>(boundingSetArray.length + 2);
        for (String boundingMember : boundingSetArray) {
            Tenant theTenant = theTenants.get(boundingMember);
            if (theTenant == null || theTenant.isDisabled()) continue;
            boundingSet.add(boundingMember);
        }
        boundingSet.add(tenantId);
        boundingSet.add("");
        String[] finalizedBoundingTenants = boundingSet.toArray(new String[boundingSet.size()]);
        account.setReadTenantIDs(finalizedBoundingTenants);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds", (Object)finalizedBoundingTenants);
    }

    private void setImpersonatedTenantID(MessageContext theContext, Map<String, Tenant> theTenants, Account account, boolean isSysAdmin, boolean isTenantAdmin) throws UnrecoverableException {
        String impersonatedTenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID");
        if (impersonatedTenantID == null) {
            return;
        }
        if (isSysAdmin || isTenantAdmin) {
            Tenant tenant = theTenants.get(impersonatedTenantID);
            if (impersonatedTenantID.isEmpty() || tenant != null) {
                this.checkIfImpersonatable(tenant, isSysAdmin);
                account.setWriteTenantID(impersonatedTenantID);
            } else {
                throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (Exception)new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DOESNT_EXIST"), (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DOESNT_EXIST")));
            }
        }
    }

    private void checkIfImpersonatable(Tenant tenant, boolean isSysAdmin) throws UnrecoverableException {
        if (tenant != null && tenant.isDisabled() && !isSysAdmin) {
            throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (Exception)new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DISABLED"), (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DISABLED")));
        }
    }

    private String setTenantID(MessageContext theContext, Map<String, Tenant> theTenants, Account account, boolean isSysAdmin) throws UnrecoverableException {
        String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
        if (tenantID == null || tenantID.equals("") || this.cmIsDisabled) {
            tenantID = "";
            account.setTenantID(tenantID);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID", (Object)tenantID);
            return tenantID;
        }
        Tenant tenant = theTenants.get(tenantID);
        if (tenant != null) {
            if (tenant.isDisabled() && !isSysAdmin) {
                RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
                LogData logData = this.logger.getLogData();
                String userId = account.getSearchPath().getValue();
                this.logger.logLogonFailureDisabledTenant(requestContext.getLogContext(), this.component, logData, tenantID, userId, requestContext.getProductLocale());
                throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (Exception)new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DISABLED")));
            }
            account.setTenantID(tenantID);
        } else if (isSysAdmin) {
            theContext.remove((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
        } else {
            RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
            LogData logData = this.logger.getLogData();
            String userId = account.getSearchPath().getValue();
            this.logger.logLogonFailureNonExistentTenant(requestContext.getLogContext(), this.component, logData, tenantID, userId, requestContext.getProductLocale());
            throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (Exception)new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DOESNT_EXIST")));
        }
        return tenantID;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.cmIsDisabled = this.getIsCMDisabled(config);
    }

    private boolean getIsCMDisabled(Configuration config) {
        boolean disableCM = false;
        if (config != null) {
            String value = config.getOptionalValue("./*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
            disableCM = Boolean.valueOf(value);
        }
        return disableCM;
    }
}

