/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyAdvancedProperties;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyConfiguration;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class AddTenantUserInfoProperties
extends DefaultHandler
implements ConfigurationListener {
    private static final String ADD_TENANT_USER_INFO_PROPERTIES_CONFIG_CHANGED = "AddTenantUserInfoProperties.configurationChanged";
    private static final String PARAMETERS = "parameters";
    private MultitenancyConfiguration mtConfig;
    private TraceLogger traceLogger;

    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, ADD_TENANT_USER_INFO_PROPERTIES_CONFIG_CHANGED);
        try {
            this.mtConfig = new MultitenancyConfiguration(theNewConfiguration);
        }
        catch (LocalizableException e) {
            LogData logData = this.traceLogger.getLogData();
            logData.setException((Exception)((Object)e));
            this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, ADD_TENANT_USER_INFO_PROPERTIES_CONFIG_CHANGED, logData);
        }
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, ADD_TENANT_USER_INFO_PROPERTIES_CONFIG_CHANGED);
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{"./*[local-name()='parameter'][@name=\"tenantIdMapping\"]", "./*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]", "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantIdMapping\"]", "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]"};
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String targetNS = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.admin.searchTargetNamespace");
        if (this.shouldAddParameters(targetNS)) {
            String[] properties = (String[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.admin.properties");
            LinkedHashSet<String> propsSet = new LinkedHashSet<String>();
            propsSet.addAll(Arrays.asList(properties));
            if (!propsSet.contains(PARAMETERS)) {
                propsSet.add(PARAMETERS);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.properties", (Object)propsSet.toArray(new String[propsSet.size()]));
                return true;
            }
        }
        return false;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.configurationChanged(config);
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
    }

    private boolean shouldAddParameters(String targetNS) {
        if (this.mtConfig.isMultitenancyEnabled()) {
            MultitenancyAdvancedProperties.AdvancedProperty tenantMappingProp = this.mtConfig.getTenancyProperty(targetNS);
            boolean tenantMappingUsesParameters = false;
            if (tenantMappingProp != null && "multitenancy.TenantPattern".equals(tenantMappingProp.getName())) {
                tenantMappingUsesParameters = tenantMappingProp.getValue().contains(PARAMETERS);
            }
            MultitenancyAdvancedProperties.AdvancedProperty boundingSetMappingProp = this.mtConfig.getBoundingSetProperty(targetNS);
            boolean boundingSetMappingUsesParameters = false;
            if (boundingSetMappingProp != null && "multitenancy.BoundingSetPattern".equals(boundingSetMappingProp.getName())) {
                boundingSetMappingUsesParameters = boundingSetMappingProp.getValue().contains(PARAMETERS);
            }
            return tenantMappingUsesParameters || boundingSetMappingUsesParameters;
        }
        return false;
    }
}

