/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;

public class CloneTenantHandler
extends DefaultHandler {
    private PassportManager passportMgr;

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        boolean tenantWasCloned = false;
        if (this.needToCloneTenant(passport)) {
            String[] readTenantIDs;
            String writeTenantID;
            QueryResult userInfo = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
            BaseClass[] baseClasses = userInfo.getAll();
            Account account = (Account)baseClasses[0];
            String passportTenantId = passport.getTenancyInfo().getTenancy(TenancyInfo.TenancyType.TENANTID);
            if (passportTenantId != null) {
                account.setTenantID(passportTenantId);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID", (Object)passportTenantId);
            }
            if ((writeTenantID = passport.getTenancyInfo().getTenancy(TenancyInfo.TenancyType.WRITE_TENANTID)) != null) {
                account.setWriteTenantID(writeTenantID);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID", (Object)writeTenantID);
            }
            if ((readTenantIDs = passport.getTenancyInfo().getTenancies(TenancyInfo.TenancyType.READ_TENANTID)) != null) {
                account.setReadTenantIDs(readTenantIDs);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.readTenantID", (Object)readTenantIDs);
            }
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenancy.handler.tenancyHasBeenCloned", (Object)Boolean.TRUE);
            tenantWasCloned = true;
        }
        return tenantWasCloned;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        super.init(theConfig);
        this.passportMgr = PassportManager.getInstance();
    }

    private boolean needToCloneTenant(Passport passport) {
        return passport != null && this.passportMgr.isNamedUserPassportID(passport.getID()) && !passport.getTenancyInfo().isUnset();
    }
}

