/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.multitenacy.handler.AddTenancyToAccount;
import java.util.HashSet;
import java.util.Set;

public class DetermineTenantsForCMQuery
extends DefaultHandler {
    private static final String ACTOR = AddTenancyToAccount.class.getName();
    private final AuditLoggerImpl logger;
    private final Component component;
    private boolean cmIsDisabled;

    public DetermineTenantsForCMQuery() {
        LogTypedLogger typedLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditIndication.class);
        this.logger = new AuditLoggerImpl(typedLogger);
        this.component = ComponentImpl.getInstance();
    }

    DetermineTenantsForCMQuery(AuditLoggerImpl auditLogger, Component theComponent) {
        this.logger = auditLogger;
        this.component = theComponent;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        HashSet<String> tenantsSet = new HashSet<String>();
        if (!this.cmIsDisabled) {
            this.getTenantID(theContext, tenantsSet);
            this.getImpersonatedTenantID(theContext, tenantsSet);
            this.getBoundingSet(theContext, tenantsSet);
            if (!tenantsSet.isEmpty()) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.soap.TenantIdsToValidate", tenantsSet);
            }
        }
        return true;
    }

    private void getBoundingSet(MessageContext theContext, Set<String> theTenants) {
        String[] boundingSetArray = (String[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds");
        if (boundingSetArray != null && boundingSetArray.length > 0 && !this.cmIsDisabled) {
            for (String boundingTenant : boundingSetArray) {
                theTenants.add(boundingTenant);
            }
        }
    }

    private void getImpersonatedTenantID(MessageContext theContext, Set<String> theTenants) throws UnrecoverableException {
        String impersonatedTenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID");
        if (impersonatedTenantID != null && !impersonatedTenantID.isEmpty() && !this.cmIsDisabled) {
            theTenants.add(impersonatedTenantID);
        }
    }

    private void getTenantID(MessageContext theContext, Set<String> theTenants) throws UnrecoverableException {
        String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
        if (tenantID != null && !tenantID.equals("") && !this.cmIsDisabled) {
            theTenants.add(tenantID);
        }
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.cmIsDisabled = this.getIsCMDisabled(config);
    }

    private boolean getIsCMDisabled(Configuration config) {
        boolean disableCM = false;
        if (config != null) {
            String value = config.getOptionalValue("./*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
            disableCM = Boolean.valueOf(value);
        }
        return disableCM;
    }
}

