/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.handler.QueryTenantMembershipBuilder;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class GetBoundingSetFromCM
extends DefaultHandler {
    private ICMAccessor cm;
    private TrustedRequestSession session;
    private boolean cmIsDisabled;

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.init(theConfig, CMAccessor.getInstance());
    }

    public void init(HandlerInfo theConfig, ICMAccessor cmAccessor) throws LocalizableException {
        this.cm = cmAccessor;
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createTrustedSession();
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.cmIsDisabled = this.getIsCMDisabled(config);
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        if (this.cmIsDisabled) {
            return true;
        }
        Element request = this.createRequest(theContext);
        String signedRequest = this.signRequest(request);
        Document response = this.sendRequest(signedRequest);
        this.retrieveBoundingSetFromResponse(theContext, response);
        return true;
    }

    private Document sendRequest(String signedRequest) throws SoapFaultException {
        try {
            return DocumentHelper.parseText((String)this.cm.invoke(signedRequest));
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
    }

    private void retrieveBoundingSetFromResponse(MessageContext theContext, Document response) {
        Set<String> tenantIds = QueryTenantMembershipBuilder.parseResponse(response);
        if (!tenantIds.isEmpty()) {
            HashSet<String> boundingSet = new HashSet<String>();
            String[] providerBoundingSet = (String[])theContext.remove((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds");
            if (providerBoundingSet != null) {
                boundingSet.addAll(Arrays.asList(providerBoundingSet));
            }
            boundingSet.addAll(tenantIds);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds", (Object)boundingSet.toArray(new String[boundingSet.size()]));
        }
    }

    private String signRequest(Element request) throws InternalErrorException {
        try {
            return new String(this.session.setMessageTrust("CAMSASVC", request.asXML().getBytes("UTF-8")), "UTF8");
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(this.getClass().toString(), e);
        }
    }

    private Element createRequest(MessageContext theContext) throws InternalErrorException {
        Element requestBody = QueryTenantMembershipBuilder.createRequestBodyForQueryTenantMembership(theContext);
        SoapEnvelopeResponse soapEnvResponse = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        try {
            Element newRequest = CMAccessor.createCMRequest(requestBody, (SoapEnvelope)soapEnvResponse);
            SoapEnvelopeRequestImpl.removeNonPropagatableRequestElements(newRequest);
            return newRequest;
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
    }

    private boolean getIsCMDisabled(Configuration config) {
        boolean disableCM = false;
        if (config != null) {
            String value = config.getOptionalValue("./*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
            disableCM = Boolean.valueOf(value);
        }
        return disableCM;
    }
}

