/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.ccl4j.util.CCLStringUtils;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerConfigTester;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyConfiguration;
import com.ibm.cognos.camaaa.internal.multitenacy.TenancyResolver;
import com.ibm.cognos.camaaa.internal.multitenacy.TenancyResolverFactory;
import com.ibm.cognos.camaaa.internal.multitenacy.TenancyResolverFactoryImpl;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class GetTenantFromProvider
extends DefaultHandler
implements ConfigurationListener {
    private static final String GET_TENANT_FROM_PROVIDER_CONFIGURATION_CHANGED = "GetTenantFromProvider.configurationChanged";
    private HashMap<String, TenancyResolver> tenantResolvers = new HashMap();
    private TraceLogger traceLogger;

    private void addTenantResolver(HandlerInfo pHandlerInfo, TenancyResolverFactory factory, String namespaceId) throws LocalizableException {
        TenancyResolver tr = this.createTenantResolver(pHandlerInfo, factory, namespaceId);
        this.tenantResolvers.put(namespaceId, tr);
    }

    @Override
    public void configurationChanged(Configuration config) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, GET_TENANT_FROM_PROVIDER_CONFIGURATION_CHANGED);
        HashMap<String, TenancyResolver> oldTenantResolvers = this.tenantResolvers;
        try {
            this.tenantResolvers = new HashMap();
            MultitenancyConfiguration mtConfig = new MultitenancyConfiguration(config);
            this.internalConfigurationChanged(mtConfig, null, false);
            this.destroy(oldTenantResolvers);
        }
        catch (LocalizableException e) {
            this.destroy();
            this.tenantResolvers = oldTenantResolvers;
            LogData logData = this.traceLogger.getLogData();
            logData.setException((Exception)((Object)e));
            this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, GET_TENANT_FROM_PROVIDER_CONFIGURATION_CHANGED, logData);
        }
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, GET_TENANT_FROM_PROVIDER_CONFIGURATION_CHANGED);
    }

    private TenancyResolver createTenantResolver(HandlerInfo pHandlerInfo, TenancyResolverFactory factory, String namespaceId) throws LocalizableException {
        TenancyResolver tr;
        if (pHandlerInfo != null) {
            String key = TenancyResolver.class.getName() + "." + namespaceId;
            tr = (TenancyResolver)pHandlerInfo.get((Object)key);
            if (tr == null) {
                tr = factory.createTenancyResolver(namespaceId);
                pHandlerInfo.put((Object)key, (Object)tr);
            }
        } else {
            tr = factory.createTenancyResolver(namespaceId);
        }
        return tr;
    }

    protected TenancyResolverFactory createTenantResolverFactory(MultitenancyConfiguration mtConfig) throws LocalizableException {
        return new TenancyResolverFactoryImpl(mtConfig);
    }

    @Override
    public void destroy() {
        this.destroy(this.tenantResolvers);
    }

    private void destroy(HashMap<String, TenancyResolver> theTenantResolvers) {
        for (TenancyResolver tr : this.tenantResolvers.values()) {
            tr.destroy();
        }
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{"./*[local-name()='parameter'][@name=\"tenantIdMapping\"]", "./*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]", "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantIdMapping\"]", "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]"};
    }

    private TenancyResolver getTenantResolver(String nsId) {
        TenancyResolver tr = this.tenantResolvers.get(nsId);
        if (tr == null) {
            return this.tenantResolvers.get(null);
        }
        return tr;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String nsId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        TenancyResolver tr = this.getTenantResolver(nsId);
        if (tr == null) {
            return true;
        }
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        QueryResult userInfo = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
        BaseClass[] baseClasses = userInfo.getAll();
        Account account = (Account)baseClasses[0];
        if (tr.canResolveTenantId()) {
            String tenant = tr.resolveTenantId(account, requestContext);
            if (!"".equals(tenant = CCLStringUtils.trimExtraWhiteSpace((String)tenant))) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID", (Object)tenant);
            }
        }
        if (tr.canResolveBoundingSet()) {
            String[] boundingSet = tr.resolveBoundingSet(account, requestContext);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds", (Object)boundingSet);
        }
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        boolean isTest;
        HandlerInfo pHandlerInfo;
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        MultitenancyConfiguration mtConfig = new MultitenancyConfiguration(config);
        boolean isMtEnabled = this.internalConfigurationChanged(mtConfig, pHandlerInfo = (HandlerInfo)theConfig.get((Object)"persistent.HandlerInfo"), isTest = theConfig.containsKey((Object)"test.namespace"));
        if (isMtEnabled && isTest) {
            HandlerConfigTester.Feedback feedback = (HandlerConfigTester.Feedback)theConfig.get((Object)"test.feedback");
            String testNSid = (String)theConfig.get((Object)"test.namespace");
            this.test(pHandlerInfo, mtConfig, feedback, testNSid);
        }
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
    }

    private void init(HandlerInfo pHandlerInfo, MultitenancyConfiguration mtConfig) throws LocalizableException {
        Set<String> namespaces = mtConfig.getNamespacesWithTenancyProps();
        TenancyResolverFactory factory = this.createTenantResolverFactory(mtConfig);
        if (namespaces != null) {
            for (String nsId : namespaces) {
                this.addTenantResolver(pHandlerInfo, factory, nsId);
            }
        }
    }

    private boolean internalConfigurationChanged(MultitenancyConfiguration mtConfig, HandlerInfo pHandlerInfo, boolean isTest) throws LocalizableException {
        boolean logEnabled;
        boolean isMtEnabled = mtConfig.isMultitenancyEnabled();
        String loggedEnabledKey = TenancyResolver.class.getName() + ".loggedEnabled";
        boolean bl = logEnabled = pHandlerInfo != null && !pHandlerInfo.containsKey((Object)loggedEnabledKey);
        if (isMtEnabled && logEnabled) {
            pHandlerInfo.put((Object)loggedEnabledKey, (Object)Boolean.TRUE);
            this.logMTisEnabled();
        }
        if (isMtEnabled && !isTest) {
            this.init(pHandlerInfo, mtConfig);
        }
        return isMtEnabled;
    }

    private void logMTisEnabled() {
        LogAuditAccessIndication indication;
        LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)"Audit.CAM.AAA", LogAuditIndication.class);
        if (ipfLogger.isEnabled(50000) && (indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber())) != null) {
            indication.setLogData(new Message("AAA_CAP_MULTITENANCY_ENABLED").getLocalizedMessage(Locale.getDefault()));
            indication.setLevel(50000);
            indication.setOperation("StartService");
            indication.setObjectType("camAsyncService");
            indication.setStatus("Info");
            ipfLogger.log((Object)indication);
        }
    }

    private void test(HandlerInfo handlerInfo, MultitenancyConfiguration mtConfig, HandlerConfigTester.Feedback feedback, String namespaceId) throws LocalizableException {
        if (namespaceId == null) {
            feedback.showInformation(new Message("AAA_CAP_MULTITENANCY_ENABLED").getLocalizedMessage(Locale.getDefault()));
        }
        TenancyResolverFactory factory = this.createTenantResolverFactory(mtConfig);
        this.addTenantResolver(handlerInfo, factory, namespaceId);
    }
}

