/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.ccl4j.util.CCLStringUtils;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeResponseImpl;

public class GetTenantIdFromFormField
extends DefaultHandler {
    static final String CAM_TENANT_ID = "CAMTenantID";

    private UserRecoverableException addTenantID(String theTenantID, UserRecoverableException exception) {
        exception.addDisplayObject((DisplayObject)new HiddenDisplayObject(CAM_TENANT_ID, theTenantID));
        return exception;
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID");
        if (tenantID == null) {
            return true;
        }
        SoapEnvelopeResponse envResponse = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        if (envResponse instanceof LegacySoapEnvelopeResponseImpl) {
            SoapFault fault = ((LegacySoapEnvelopeResponseImpl)envResponse).getFaultEntry();
            if (fault instanceof UserRecoverableException) {
                envResponse.setFaultEntry((SoapFault)this.addTenantID(tenantID, (UserRecoverableException)fault), theContext);
            }
        } else {
            SoapBodyResponse body = (SoapBodyResponse)envResponse.getBody();
            SoapBodyEntry bodyEntry = body.getBodyEntry();
            if (bodyEntry instanceof UserRecoverableException) {
                body.setFaultBodyEntry((SoapFault)this.addTenantID(tenantID, (UserRecoverableException)bodyEntry));
            }
        }
        return true;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapHeader header = request.getHeader();
        BiBusHeader bibusHdr = header.getBiBusHeader();
        String[] tenantIds = bibusHdr.getFormFieldValues(CAM_TENANT_ID);
        if (tenantIds != null) {
            bibusHdr.consumeFormField(CAM_TENANT_ID);
            if (tenantIds.length > 0) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID", (Object)CCLStringUtils.trimExtraWhiteSpace((String)tenantIds[0]));
                return true;
            }
        }
        return false;
    }
}

