/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyAdvancedProperties;
import com.ibm.cognos.camaaa.internal.multitenacy.MultitenancyConfiguration;

public class IsMultitenancyEnabled
extends DefaultHandler
implements ConfigurationListener {
    public static final String MT_ID_MAPPING = "/*[local-name()='parameter'][@name=\"tenantIdMapping\"]";
    public static final String MT_BOUNDING_SET_MAPPING = "/*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]";
    public static final String GLOBAL_MT_ID_MAPPING = "./*[local-name()='parameter'][@name=\"tenantIdMapping\"]";
    public static final String GLOBAL_MT_BOUNDING_SET_MAPPING = "./*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]";
    public static final String INSTANCE_MT_ID_MAPPING = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantIdMapping\"]";
    public static final String INSTANCE_MT_BOUNDING_SET_MAPPING = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']/*[local-name()='parameter'][@name=\"tenantBoundingSetMapping\"]";
    private static final String IS_MULTITENANCY_ENABLED_CONFIGURATION_CHANGED = "IsMultitenancyEnabled.configurationChanged";
    private MultitenancyConfiguration mtConfig;
    private TraceLogger traceLogger;

    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, IS_MULTITENANCY_ENABLED_CONFIGURATION_CHANGED);
        LogData logData = this.traceLogger.getLogData();
        try {
            boolean mtCurrentlyEnabled = this.mtConfig.isMultitenancyEnabled();
            MultitenancyAdvancedProperties.AdvancedProperty oldGlobalTenancyProp = this.mtConfig.getTenancyPropertyNS(null);
            MultitenancyAdvancedProperties.AdvancedProperty oldGlobalBoundingSetProp = this.mtConfig.getBoundingSetPropertyNS(null);
            this.internalConfigurationChanged(theNewConfiguration);
            boolean newMtCurrentlyEnabled = this.mtConfig.isMultitenancyEnabled();
            MultitenancyAdvancedProperties.AdvancedProperty newGlobalTenancyProp = this.mtConfig.getTenancyPropertyNS(null);
            MultitenancyAdvancedProperties.AdvancedProperty newGlobalBoundingSetProp = this.mtConfig.getBoundingSetPropertyNS(null);
            logData.addParameter("Old MT enabled", Boolean.toString(mtCurrentlyEnabled));
            logData.addParameter("New MT enabled", Boolean.toString(newMtCurrentlyEnabled));
            this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "IsMultitenancyEnabled.values", logData);
            if ((oldGlobalTenancyProp != newGlobalTenancyProp || oldGlobalBoundingSetProp != newGlobalBoundingSetProp) && (this.hasAdvancedPropertyChanged(oldGlobalTenancyProp, newGlobalTenancyProp) || this.hasAdvancedPropertyChanged(oldGlobalBoundingSetProp, newGlobalBoundingSetProp))) {
                this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "IsMultitenancyEnabled.globalMTChanged");
                PassportManager.getInstance().terminateSessions(passport -> true);
            }
        }
        catch (LocalizableException e) {
            logData.setException((Exception)((Object)e));
            this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, IS_MULTITENANCY_ENABLED_CONFIGURATION_CHANGED, logData);
        }
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, IS_MULTITENANCY_ENABLED_CONFIGURATION_CHANGED);
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{GLOBAL_MT_ID_MAPPING, GLOBAL_MT_BOUNDING_SET_MAPPING, INSTANCE_MT_ID_MAPPING, INSTANCE_MT_BOUNDING_SET_MAPPING};
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        return this.mtConfig.isMultitenancyEnabled();
    }

    private boolean hasAdvancedPropertyChanged(MultitenancyAdvancedProperties.AdvancedProperty oldAdvProp, MultitenancyAdvancedProperties.AdvancedProperty newAdvProp) {
        if (oldAdvProp == null && newAdvProp == null) {
            return false;
        }
        if (oldAdvProp == null && newAdvProp != null || oldAdvProp != null && newAdvProp == null) {
            return true;
        }
        return !oldAdvProp.getName().equals(newAdvProp.getName()) || !oldAdvProp.getValue().equals(newAdvProp.getValue());
    }

    private void internalConfigurationChanged(Configuration theConfig) throws LocalizableException {
        this.mtConfig = new MultitenancyConfiguration(theConfig);
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        this.internalConfigurationChanged(config);
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
    }
}

