/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class SelectTenants
extends DefaultHandler {
    private static final String ACTOR = SelectTenants.class.getName();
    private String readTenantId;
    private String writeTenantId;

    private void determineResultantTenancy(MessageContext theContext) throws InvalidRequestException {
        if (this.readTenantId != null && this.writeTenantId != null && !this.readTenantId.equals(this.writeTenantId)) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_REQ_E_SELECT_TENANTS_DIFFERENT_TENANTIDS"));
        }
        if (this.readTenantId != null && this.writeTenantId == null) {
            this.writeTenantId = this.readTenantId;
        }
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        this.readTenantId = (String)theContext.remove((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsReadTenantIDs");
        this.writeTenantId = (String)theContext.remove((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsWriteTenantID");
        this.determineResultantTenancy(theContext);
        this.setTenancy(theContext);
        return true;
    }

    private void setTenancy(MessageContext theContext) {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        TenancyInfo tenancyInfo = passport.getTenancyInfo();
        tenancyInfo.setTenancy(TenancyInfo.TenancyType.READ_TENANTID, this.readTenantId);
        tenancyInfo.setTenancy(TenancyInfo.TenancyType.WRITE_TENANTID, this.writeTenantId);
        tenancyInfo.setIsImpersonating(this.readTenantId != null || this.writeTenantId != null);
    }
}

