/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.SelectTenantsRequest;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashSet;
import java.util.Set;

public class SelectTenantsPreprocessing
extends DefaultHandler {
    private static final String ACTOR = SelectTenantsPreprocessing.class.getName();
    private String readTenantId;
    private String writeTenantId;

    private void configureValidationStep(MessageContext theContext) {
        HashSet<String> tenantIdsToValidate = new HashSet<String>(2);
        if (this.readTenantId != null && !"".equals(this.readTenantId)) {
            tenantIdsToValidate.add(this.readTenantId);
        }
        if (this.writeTenantId != null && !this.writeTenantId.equals(this.readTenantId) && !"".equals(this.writeTenantId)) {
            tenantIdsToValidate.add(this.writeTenantId);
        }
        if (!tenantIdsToValidate.isEmpty()) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.soap.TenantIdsToValidate", tenantIdsToValidate);
        }
    }

    private void extractTenantIds(MessageContext theContext) {
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SelectTenantsRequest selectTenantsReq = (SelectTenantsRequest)request.getBody().getBodyEntry();
        this.readTenantId = selectTenantsReq.getReadTenantID();
        if (this.readTenantId != null) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsReadTenantIDs", (Object)this.readTenantId);
        }
        this.writeTenantId = selectTenantsReq.getWriteTenantID();
        if (this.writeTenantId != null) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.selectTenantsWriteTenantID", (Object)this.writeTenantId);
        }
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        this.verifyUserIsSysOrTenantAdmin(theContext);
        this.extractTenantIds(theContext);
        this.configureValidationStep(theContext);
        return true;
    }

    private void verifyUserIsSysOrTenantAdmin(MessageContext theContext) throws InvalidRequestException {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        Set<String> roles = passport.getRoles();
        if (!roles.contains("CAMID(\"::System Administrators\")") && !roles.contains("CAMID(\"::Tenant Administrators\")")) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_REQ_E_MUST_BE_SYSORTENANTADMIN"));
        }
    }
}

