/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Tenant;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidRequestException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Set;

public class ValidateTenants
extends DefaultHandler {
    private static final String ACTOR = ValidateTenants.class.getName();

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        BaseClass[] tenants;
        Set toValidate = (Set)theContext.remove((Object)"com.ibm.cognos.camaaa.internal.admin.soap.TenantIdsToValidate");
        for (BaseClass bdTenant : tenants = (BaseClass[])theContext.remove((Object)"com.ibm.cognos.camaaa.internal.admin.handler.ExtractTenantInfo.TENANT_INFO")) {
            Tenant tenant = (Tenant)bdTenant;
            if (!toValidate.remove(tenant.getTenantID())) continue;
            this.checkIfImpersonatable(tenant, theContext);
        }
        if (!toValidate.isEmpty()) {
            throw new InvalidRequestException(ACTOR, (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DOESNT_EXIST", new Object[]{toValidate.iterator().next()}));
        }
        return true;
    }

    private void checkIfImpersonatable(Tenant tenant, MessageContext theContext) throws UnrecoverableException {
        if (tenant.isDisabled() && this.isUserJustTenantAdmin(theContext)) {
            throw new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (LocalizableMessage)new Message("AAA_CAP_MULTITENANCY_IMPERSONATE_FAILED"), (Exception)new UnrecoverableException(ACTOR, (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DISABLED"), (LocalizableMessage)new Message("AAA_AUT_MT_TENANT_DISABLED")));
        }
    }

    private boolean isUserJustTenantAdmin(MessageContext theContext) {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        Set<String> roles = passport.getRoles();
        return !roles.contains("CAMID(\"::System Administrators\")") && roles.contains("CAMID(\"::Tenant Administrators\")");
    }
}

