/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.multitenacy.handler;

import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.Iterator;
import java.util.Set;

public class ValidateTenantsPreprocessing
extends DefaultHandler {
    private static final String APOS = "'";
    private static final String ESCAPED_APOS = "''";

    private String constructTenantsSearchPath(Set<String> tenants) {
        StringBuilder builder = new StringBuilder();
        builder.append("/directory/tenants/tenant[@tenantID='");
        Iterator<String> tenantsIterator = tenants.iterator();
        while (tenantsIterator.hasNext()) {
            builder.append(this.escapeForSearchPathArgument(tenantsIterator.next())).append(APOS);
            if (!tenantsIterator.hasNext()) continue;
            builder.append(" or @tenantID='");
        }
        builder.append("]");
        return builder.toString();
    }

    private String escapeForSearchPathArgument(String string) {
        return string.replaceAll(APOS, ESCAPED_APOS);
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Set tenantIdsToValidate = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.admin.soap.TenantIdsToValidate");
        if (tenantIdsToValidate == null || tenantIdsToValidate.isEmpty()) {
            return true;
        }
        String searchPath = this.constructTenantsSearchPath(tenantIdsToValidate);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.soap.TenantSearchPath", (Object)searchPath);
        return false;
    }
}

