<?xml version="1.0" encoding="UTF-8"?>
<!--
    Licensed Materials - Property of IBM

    IBM Cognos Products: CAMAAA

    (C) Copyright IBM Corp. 2011, 2012

    US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with
    IBM Corp.
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="/">
		<handler-configuration version="0.2"
			xmlns="http://developer.cognos.com/schemas/CAM/AAA/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xsi:schemaLocation="http://developer.cognos.com/schemas/CAM/AAA/2/
NamespaceConfig.xsd">
			<handler-chains>
				<auth-handler-chain name="test">
					<xsl:for-each
						select="descendant::*[local-name()='auth-handler' or local-name()='admin-handler'][not(@test) or @test='true']">
						<xsl:sort select="@handler" />
						<xsl:copy-of select="." />
					</xsl:for-each>
				</auth-handler-chain>
			</handler-chains>
			<actions>
				<action request="validate" handler="test" />
			</actions>
		</handler-configuration>
	</xsl:template>

</xsl:stylesheet>
