/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.TransactionContextImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfo;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.util.Messages;

public class DatabaseImpl
implements Database,
Synchronization {
    private static Log _log = LogFactory.getFactory().getInstance(SQLEngine.class);
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private int _lockTimeout;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private String _dbName;
    private Transaction _transaction;
    private boolean _autoStore;
    private ClassLoader _classLoader;
    private TxDatabaseMap _txMap;

    public DatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, Transaction transaction, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        _log.debug((Object)("Fetching DatabaseRegistry: " + dbName));
        DatabaseRegistry dbs = DatabaseRegistry.getDatabaseRegistry(dbName);
        if (dbs == null) {
            throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", dbName));
        }
        LockEngine[] pe = new LockEngine[]{DatabaseRegistry.getLockEngine(dbs)};
        this._scope = new PersistenceInfoGroup(pe);
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._transaction = transaction;
        if (this._transaction != null) {
            this._ctx = new TransactionContextImpl((Database)this, true);
            this._ctx.setLockTimeout(this._lockTimeout);
            this._ctx.setAutoStore(this._autoStore);
            this._ctx.setCallback(this._callback);
            this._ctx.setInstanceFactory(this._instanceFactory);
        }
        this._classLoader = classLoader;
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PersistenceException {
        block10: {
            try {
                if (this._transaction == null) {
                    if (this._ctx == null || !this._ctx.isOpen()) break block10;
                    try {
                        this._ctx.rollback();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    try {
                        this._ctx.close();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    throw new PersistenceException(Messages.message("jdo.dbClosedTxRolledback"));
                }
                if (this._ctx == null || !this._ctx.isOpen()) break block10;
                try {
                    this._ctx.close();
                }
                catch (Exception e) {
                    throw new PersistenceException(e.getMessage());
                }
            }
            finally {
                this._scope = null;
            }
        }
    }

    public boolean isClosed() {
        return this._scope == null;
    }

    public Object load(Class type, Object identity, Object object) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", type.getName()));
        }
        return tx.load(info.engine, info.molder, identity, object, null);
    }

    public Object load(Class type, Complex identity) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, (Object)identity, null);
    }

    public Object load(Class type, Object identity) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        return this.load(type, identity, null);
    }

    public Object load(Class type, Complex identity, short accessMode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, (Object)identity, accessMode);
    }

    public Object load(Class type, Object identity, short accessMode) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        AccessMode mode;
        switch (accessMode) {
            case 0: {
                mode = AccessMode.ReadOnly;
                break;
            }
            case 1: {
                mode = AccessMode.Shared;
                break;
            }
            case 2: {
                mode = AccessMode.Exclusive;
                break;
            }
            case 3: {
                mode = AccessMode.DbLocked;
                break;
            }
            default: {
                throw new IllegalArgumentException("Value for 'accessMode' is invalid");
            }
        }
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", type.getName()));
        }
        return tx.load(info.engine, info.molder, identity, null, mode);
    }

    public void create(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.create(info.engine, info.molder, object, null);
    }

    public void update(Object object) throws ClassNotPersistenceCapableException, ObjectModifiedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.update(info.engine, info.molder, object, null);
    }

    public void remove(Object object) throws ObjectNotPersistentException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.delete(object);
    }

    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    public Object getIdentity(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.getIdentity(object);
        }
        return null;
    }

    public void lock(Object object) throws LockNotGrantedException, ObjectNotPersistentException, TransactionNotInProgressException, PersistenceException {
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    public OQLQuery getOQLQuery(String oql) throws QueryException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected void finalize() throws Throwable {
        if (this._scope != null) {
            OQLQuery oqlQuery = this.getOQLQuery();
            String sql = ((OQLQueryImpl)oqlQuery).getSQL();
            _log.warn((Object)Messages.format("jdo.finalize_close", this.toString(), this._dbName, sql));
            this.close();
        }
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message("jdo.dbTxNotInProgress"));
    }

    public void begin() throws PersistenceException {
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            throw new PersistenceException(Messages.message("jdo.txInProgress"));
        }
        this._ctx = new TransactionContextImpl((Database)this, false);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
    }

    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        if (this._ctx.getStatus() == 1) {
            throw new TransactionAbortedException(Messages.message("jdo.txAborted"));
        }
        try {
            this._ctx.prepare();
            this._ctx.commit();
        }
        catch (TransactionAbortedException except) {
            this._ctx.rollback();
            throw except;
        }
        finally {
            try {
                this._ctx.close();
            }
            catch (Exception exception) {}
            this._ctx = null;
        }
    }

    public void rollback() throws TransactionNotInProgressException {
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.rollback();
        this._ctx = null;
    }

    public void beforeCompletion() {
        if (this._transaction == null || this._ctx == null || !this._ctx.isOpen()) {
            throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
        }
        if (this._ctx.getStatus() == 1) {
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException except) {
                _log.warn((Object)Messages.format("jdo.warnException", (Object)except));
            }
            return;
        }
        try {
            this._ctx.prepare();
        }
        catch (TransactionAbortedException except) {
            _log.fatal((Object)Messages.format("jdo.fatalException", except));
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException except2) {
                _log.fatal((Object)Messages.format("jdo.fatalException", (Object)except2));
            }
            this._ctx.rollback();
        }
    }

    public void afterCompletion(int status) {
        try {
            if (this._transaction == null || this._ctx == null) {
                throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
            }
            if (this._ctx.getStatus() == 4) {
                return;
            }
            if (this._ctx.getStatus() != 2 && status != 4) {
                throw new IllegalStateException("Unexpected state: afterCompletion called at status " + this._ctx.getStatus());
            }
            switch (status) {
                case 3: {
                    try {
                        this._ctx.commit();
                    }
                    catch (TransactionAbortedException except) {
                        _log.fatal((Object)Messages.format("jdo.fatalException", except));
                        this._ctx.rollback();
                    }
                    this._ctx = null;
                    return;
                }
                case 4: {
                    this._ctx.rollback();
                    this._ctx = null;
                    return;
                }
            }
            this._ctx.rollback();
            this._ctx = null;
            throw new IllegalStateException("Unexpected state: afterCompletion called with status " + status);
        }
        finally {
            if (this._txMap != null && this._transaction != null) {
                this._txMap.remove(this._transaction);
                this._txMap = null;
            }
        }
    }

    void setTxMap(TxDatabaseMap txMap) {
        this._txMap = txMap;
    }

    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    public Object getConnection() throws PersistenceException {
        return this._ctx.getConnection(this._scope.getLockEngine());
    }

    public void expireCache(Class[] type, Object[] identity) throws PersistenceException {
        for (int i = 0; i < type.length; ++i) {
            LockEngine engine = this.getLockEngine();
            if (identity != null) {
                if (identity.length >= i + 1) {
                    ClassMolder molder = engine.getClassMolder(type[i]);
                    this.begin();
                    TransactionContext tx = this.getTransaction();
                    tx.expireCache(engine, molder, identity[i]);
                    this.commit();
                    continue;
                }
                engine.expireCache(type[i]);
                continue;
            }
            engine.expireCache(type[i]);
        }
    }
}

