/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.engine.ClobImpl;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.types.Duration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.MimeBase64Decoder;
import org.exolab.castor.util.MimeBase64Encoder;

public final class SQLTypes {
    private static Log log = LogFactory.getFactory().getInstance(Class.class);
    private static final char SQLWordSeparator = '_';
    private static final char LeftParamSeparator = '[';
    private static final char RightParamSeparator = ']';
    static TypeInfo[] _typeInfos = new TypeInfo[]{new TypeInfo(-7, "bit", Boolean.class), new TypeInfo(-6, "tinyint", Byte.class), new TypeInfo(5, "smallint", Short.class), new TypeInfo(4, "integer", Integer.class), new TypeInfo(-5, "bigint", Long.class), new TypeInfo(6, "float", Double.class), new TypeInfo(8, "double", Double.class), new TypeInfo(7, "real", Float.class), new TypeInfo(2, "numeric", BigDecimal.class), new TypeInfo(3, "decimal", BigDecimal.class), new TypeInfo(1, "char", String.class), new TypeInfo(12, "varchar", String.class), new TypeInfo(-1, "longvarchar", String.class), new TypeInfo(91, "date", Date.class), new TypeInfo(92, "time", Time.class), new TypeInfo(93, "timestamp", Timestamp.class), new TypeInfo(-2, "binary", [B.class), new TypeInfo(-3, "varbinary", [B.class), new TypeInfo(-4, "longvarbinary", [B.class), new TypeInfo(1111, "other", Object.class), new TypeInfo(2000, "javaobject", Object.class), new TypeInfo(2004, "blob", InputStream.class), new TypeInfo(2005, "clob", Clob.class)};
    private static DateFormat _dateFormat = new SimpleDateFormat();
    private static SimpleDateFormat _paramDateFormat = new SimpleDateFormat();
    private static DecimalFormat _decimalFormat = new DecimalFormat("#################0");
    static TypeConvertorInfo[] _typeConvertors = new TypeConvertorInfo[]{new TypeConvertorInfo(new SQLTypeConvertor(Short.class, Boolean.class){

        public Object convert(Object obj, String param) {
            return (Short)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Boolean.class, Short.class){

        public Object convert(Object obj, String param) {
            return new Short((Boolean)obj != false ? (short)1 : 0);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Boolean.class){

        public Object convert(Object obj, String param) {
            return (Integer)obj == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Boolean.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer((Boolean)obj != false ? 1 : 0);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Boolean.class){

        public Object convert(Object obj, String param) {
            switch (((String)obj).length()) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    char ch = ((String)obj).charAt(0);
                    if (param == null || param.length() != 2) {
                        return ch == 'T' || ch == 't' ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return ch == param.charAt(1) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 4: {
                    return ((String)obj).equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                case 5: {
                    return ((String)obj).equalsIgnoreCase("false") ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            return Boolean.FALSE;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Boolean.class){

        public Object convert(Object obj, String param) {
            return new Boolean(((BigDecimal)obj).intValue() != 0);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Byte.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((Byte)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Short.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((Short)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((Long)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Float.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((Float)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((Double)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Integer.class){

        public Object convert(Object obj, String param) {
            return new Integer(((BigDecimal)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Integer.class){

        public Object convert(Object obj, String param) {
            return Integer.valueOf((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Integer.class){

        public Object convert(Object obj, String param) {
            SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
            paramDateFormat.applyPattern(Types.getFullDatePattern(param));
            return new Integer(paramDateFormat.format((java.util.Date)obj));
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((Integer)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Short.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((Short)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Float.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((Float)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((Double)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((BigDecimal)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Long.class){

        public Object convert(Object obj, String param) {
            return Long.valueOf((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((java.util.Date)obj).getTime());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Byte.class, Short.class){

        public Object convert(Object obj, String param) {
            return new Short(((Byte)obj).shortValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Short.class){

        public Object convert(Object obj, String param) {
            return new Short(((Integer)obj).shortValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, Short.class){

        public Object convert(Object obj, String param) {
            return new Short(((Long)obj).shortValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Short.class){

        public Object convert(Object obj, String param) {
            return new Short((short)((BigDecimal)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Short.class){

        public Object convert(Object obj, String param) {
            return Short.valueOf((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Short.class, Byte.class){

        public Object convert(Object obj, String param) {
            return new Byte(((Short)obj).byteValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Byte.class){

        public Object convert(Object obj, String param) {
            return new Byte(((Integer)obj).byteValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Byte.class){

        public Object convert(Object obj, String param) {
            return new Byte((byte)((BigDecimal)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Float.class, Double.class){

        public Object convert(Object obj, String param) {
            return new Double(((Float)obj).floatValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Double.class){

        public Object convert(Object obj, String param) {
            return new Double(((Integer)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, Double.class){

        public Object convert(Object obj, String param) {
            return new Double(((Long)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Double.class){

        public Object convert(Object obj, String param) {
            return new Double(((BigDecimal)obj).doubleValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Double.class){

        public Object convert(Object obj, String param) {
            SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
            paramDateFormat.applyPattern(Types.getFullDatePattern(param));
            return new Double(paramDateFormat.format((java.util.Date)obj));
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Double.class){

        public Object convert(Object obj, String param) {
            return Double.valueOf((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, Float.class){

        public Object convert(Object obj, String param) {
            return new Float(((Double)obj).floatValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, Float.class){

        public Object convert(Object obj, String param) {
            return new Float(((Integer)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, Float.class){

        public Object convert(Object obj, String param) {
            return new Float(((Long)obj).longValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, Float.class){

        public Object convert(Object obj, String param) {
            return new Float(((BigDecimal)obj).floatValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Float.class){

        public Object convert(Object obj, String param) {
            return Float.valueOf((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return new BigDecimal(((Double)obj).toString());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Float.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return new BigDecimal(((Float)obj).toString());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return BigDecimal.valueOf(((Integer)obj).intValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Byte.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return BigDecimal.valueOf(((Byte)obj).byteValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Short.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return BigDecimal.valueOf(((Short)obj).shortValue());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return BigDecimal.valueOf((Long)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return new BigDecimal((String)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
            paramDateFormat.applyPattern(Types.getFullDatePattern(param));
            return new BigDecimal(new BigInteger(paramDateFormat.format((java.util.Date)obj)));
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Boolean.class, BigDecimal.class){

        public Object convert(Object obj, String param) {
            return BigDecimal.valueOf((Boolean)obj != false ? 1L : 0L);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Short.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Float.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Object.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, String.class){

        public Object convert(Object obj, String param) {
            if (param == null || param.length() == 0) {
                return obj.toString();
            }
            SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
            paramDateFormat.applyPattern(param);
            return paramDateFormat.format((java.util.Date)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Character.class, String.class){

        public Object convert(Object obj, String param) {
            return obj.toString();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor([C.class, String.class){

        public Object convert(Object obj, String param) {
            return new String((char[])obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor([B.class, String.class){

        public Object convert(Object obj, String param) {
            MimeBase64Encoder encoder = new MimeBase64Encoder();
            encoder.translate((byte[])obj);
            return new String(encoder.getCharArray());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Boolean.class, String.class){

        public Object convert(Object obj, String param) {
            if (param == null || param.length() != 2) {
                return (Boolean)obj != false ? "T" : "F";
            }
            return (Boolean)obj != false ? param.substring(1, 2) : param.substring(0, 1);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Character.class){

        public Object convert(Object obj, String param) {
            String str = (String)obj;
            return new Character(str.length() == 0 ? (char)'\u0000' : str.charAt(0));
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, [C.class){

        public Object convert(Object obj, String param) {
            return ((String)obj).toCharArray();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, [B.class){

        public Object convert(Object obj, String param) {
            MimeBase64Decoder decoder = new MimeBase64Decoder();
            decoder.translate((String)obj);
            return decoder.getByteArray();
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            return new java.util.Date((Long)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            try {
                if (param == null || param.length() == 0) {
                    return SQLTypes.getDateFormat().parse((String)obj);
                }
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(param);
                return paramDateFormat.parse((String)obj);
            }
            catch (ParseException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Integer.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return paramDateFormat.parse(obj.toString());
            }
            catch (ParseException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(BigDecimal.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return paramDateFormat.parse(obj.toString());
            }
            catch (ParseException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Double.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            try {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(Types.getFullDatePattern(param));
                return paramDateFormat.parse(SQLTypes.getDecimalFormat().format(obj).trim());
            }
            catch (ParseException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Date.class){

        public Object convert(Object obj, String param) {
            return new Date(((java.util.Date)obj).getTime());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Date.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            return obj;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Time.class){

        public Object convert(Object obj, String param) {
            return new Time(((java.util.Date)obj).getTime());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Time.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            return obj;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, Timestamp.class){

        public Object convert(Object obj, String param) {
            long time = ((java.util.Date)obj).getTime();
            Timestamp timestamp = new Timestamp(time);
            return timestamp;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Timestamp.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            Timestamp timestamp = (Timestamp)obj;
            return new java.util.Date(timestamp.getTime());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Timestamp.class){

        public Object convert(Object obj, String param) {
            long time;
            if (param == null || param.length() == 0) {
                param = "yyyy-MM-dd HH:mm:ss.SSS";
            }
            try {
                SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
                paramDateFormat.applyPattern(param);
                time = paramDateFormat.parse((String)obj).getTime();
            }
            catch (ParseException except) {
                throw new IllegalArgumentException(except.toString());
            }
            Timestamp timestamp = new Timestamp(time);
            timestamp.setNanos((int)(time % 1000L * 1000000L));
            return timestamp;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Timestamp.class, String.class){

        public Object convert(Object obj, String param) {
            if (param == null || param.length() == 0) {
                param = "yyyy-MM-dd HH:mm:ss.SSS";
            }
            Timestamp timestamp = (Timestamp)obj;
            SimpleDateFormat paramDateFormat = SQLTypes.getParamDateFormat();
            paramDateFormat.applyPattern(param);
            return paramDateFormat.format(new java.util.Date(timestamp.getTime() + (long)(timestamp.getNanos() / 1000000)));
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor([B.class, InputStream.class){

        public Object convert(Object obj, String param) {
            return new ByteArrayInputStream((byte[])obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(InputStream.class, [B.class){

        public Object convert(Object obj, String param) {
            try {
                InputStream is = (InputStream)obj;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[SQLTypes.loadLobBufferSize()];
                int len = 0;
                while ((len = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                return bos.toByteArray();
            }
            catch (IOException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(String.class, Clob.class){

        public Object convert(Object obj, String param) {
            String str = (String)obj;
            return new ClobImpl(new StringReader(str), str.length());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor([C.class, Clob.class){

        public Object convert(Object obj, String param) {
            char[] chars = (char[])obj;
            return new ClobImpl(new CharArrayReader(chars), chars.length);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Clob.class, String.class){

        public Object convert(Object obj, String param) {
            try {
                Reader reader = ((Clob)obj).getCharacterStream();
                CharArrayWriter writer = new CharArrayWriter();
                char[] buffer = new char[SQLTypes.loadLobBufferSize()];
                int len = 0;
                while ((len = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, len);
                }
                return writer.toString();
            }
            catch (Exception except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Clob.class, [C.class){

        public Object convert(Object obj, String param) {
            try {
                Reader reader = ((Clob)obj).getCharacterStream();
                CharArrayWriter writer = new CharArrayWriter();
                char[] buffer = new char[SQLTypes.loadLobBufferSize()];
                int len = 0;
                while ((len = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, len);
                }
                return writer.toCharArray();
            }
            catch (Exception except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(java.util.Date.class, org.exolab.castor.types.Date.class){

        public Object convert(Object obj, String param) {
            return new org.exolab.castor.types.Date((java.util.Date)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(org.exolab.castor.types.Date.class, java.util.Date.class){

        public Object convert(Object obj, String param) {
            java.util.Date result = null;
            result = ((org.exolab.castor.types.Date)obj).toDate();
            return result;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Date.class, org.exolab.castor.types.Date.class){

        public Object convert(Object obj, String param) {
            return new org.exolab.castor.types.Date((java.util.Date)obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(org.exolab.castor.types.Date.class, Date.class){

        public Object convert(Object obj, String param) {
            Date result = null;
            result = new Date(((org.exolab.castor.types.Date)obj).toDate().getTime());
            return result;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Serializable.class, InputStream.class){

        public Object convert(Object obj, String param) {
            return new ByteArrayInputStream((byte[])obj);
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(InputStream.class, Serializable.class){

        public Object convert(Object obj, String param) {
            try {
                InputStream is = (InputStream)obj;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[SQLTypes.loadLobBufferSize()];
                int len = 0;
                while ((len = is.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                return bos.toByteArray();
            }
            catch (IOException except) {
                throw new IllegalArgumentException(except.toString());
            }
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Serializable.class, [B.class){

        public Object convert(Object obj, String param) {
            return obj;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor([B.class, Serializable.class){

        public Object convert(Object obj, String param) {
            return obj;
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Duration.class, Long.class){

        public Object convert(Object obj, String param) {
            return new Long(((Duration)obj).toLong());
        }
    }), new TypeConvertorInfo(new SQLTypeConvertor(Long.class, Duration.class){

        public Object convert(Object obj, String param) {
            return new Duration((Long)obj);
        }
    })};

    private static int loadLobBufferSize() {
        int lobSize;
        String lobBufferSizeProperty = "org.exolab.castor.jdo.lobBufferSize";
        String lobSizeProp = LocalConfiguration.getInstance().getProperty(lobBufferSizeProperty, "");
        try {
            lobSize = Integer.parseInt(lobSizeProp.trim());
        }
        catch (NumberFormatException nfe) {
            lobSize = 256;
        }
        return lobSize;
    }

    public static Class typeFromName(String sqlTypeName) throws MappingException {
        int sep = sqlTypeName.indexOf(91);
        if (sep >= 0) {
            sqlTypeName = sqlTypeName.substring(0, sep);
        }
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!sqlTypeName.equals(SQLTypes._typeInfos[i].sqlTypeName)) continue;
            return SQLTypes._typeInfos[i].javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", sqlTypeName);
    }

    public static int sqlTypeFromName(String sqlTypeName) throws MappingException {
        int sep = sqlTypeName.indexOf(91);
        if (sep >= 0) {
            sqlTypeName = sqlTypeName.substring(0, sep);
        }
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!sqlTypeName.equals(SQLTypes._typeInfos[i].sqlTypeName)) continue;
            return SQLTypes._typeInfos[i].sqlType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", sqlTypeName);
    }

    public static String paramFromName(String sqlTypeName) {
        int left = sqlTypeName.indexOf(91);
        int right = sqlTypeName.indexOf(93);
        if (right < 0) {
            right = sqlTypeName.length();
        }
        if (left >= 0) {
            return sqlTypeName.substring(left + 1, right);
        }
        return null;
    }

    public static Class typeFromSQLType(int sqlType) throws MappingException {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (sqlType != SQLTypes._typeInfos[i].sqlType) continue;
            return SQLTypes._typeInfos[i].javaType;
        }
        throw new MappingException("jdo.sqlTypeNotSupported", new Integer(sqlType));
    }

    public static int getSQLType(Class javaType) {
        for (int i = 0; i < _typeInfos.length; ++i) {
            if (!javaType.isAssignableFrom(SQLTypes._typeInfos[i].javaType)) continue;
            return SQLTypes._typeInfos[i].sqlType;
        }
        return 1111;
    }

    public static String javaToSqlName(String javaName) {
        if (javaName.indexOf(46) > 0) {
            javaName = javaName.substring(javaName.lastIndexOf(46) + 1);
        }
        StringBuffer sql = new StringBuffer(javaName.length());
        boolean wasLower = false;
        for (int i = 0; i < javaName.length(); ++i) {
            char ch = javaName.charAt(i);
            if (i > 0 && Character.isUpperCase(ch)) {
                if (wasLower) {
                    sql.append('_');
                } else if (i < javaName.length() - 1 && Character.isLowerCase(javaName.charAt(i + 1))) {
                    sql.append('_');
                }
            }
            wasLower = Character.isLowerCase(ch);
            sql.append(Character.toLowerCase(ch));
        }
        return sql.toString();
    }

    public static String sqlToJavaName(String sqlName, boolean className, String scope) {
        StringBuffer java = new StringBuffer(sqlName.length());
        if (scope != null) {
            java.append(scope).append('.');
        }
        for (int i = 0; i < sqlName.length(); ++i) {
            if (i == 0 && className) {
                java.append(Character.toUpperCase(sqlName.charAt(i)));
                continue;
            }
            if (sqlName.charAt(i) == '_') {
                if (++i >= sqlName.length()) continue;
                java.append(Character.toUpperCase(sqlName.charAt(i)));
                continue;
            }
            java.append(Character.toLowerCase(sqlName.charAt(i)));
        }
        return java.toString();
    }

    public static Object getObject(ResultSet rs, int index, int sqlType) throws SQLException {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return rs.getString(index);
            }
            case 2: 
            case 3: {
                return rs.getBigDecimal(index);
            }
            case 4: {
                int intVal = rs.getInt(index);
                return rs.wasNull() ? null : new Integer(intVal);
            }
            case 92: {
                return rs.getTime(index);
            }
            case 91: {
                return rs.getDate(index);
            }
            case 93: {
                return rs.getTimestamp(index);
            }
            case 6: 
            case 8: {
                double doubleVal = rs.getDouble(index);
                return rs.wasNull() ? null : new Double(doubleVal);
            }
            case 7: {
                float floatVal = rs.getFloat(index);
                return rs.wasNull() ? null : new Float(floatVal);
            }
            case 5: {
                short shortVal = rs.getShort(index);
                return rs.wasNull() ? null : new Short(shortVal);
            }
            case -6: {
                byte byteVal = rs.getByte(index);
                return rs.wasNull() ? null : new Byte(byteVal);
            }
            case -4: 
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case 2004: {
                Blob blob = rs.getBlob(index);
                return blob == null ? null : blob.getBinaryStream();
            }
            case 2005: {
                return rs.getClob(index);
            }
            case -5: {
                long longVal = rs.getLong(index);
                return rs.wasNull() ? null : new Long(longVal);
            }
            case -7: {
                boolean boolVal = rs.getBoolean(index);
                return rs.wasNull() ? null : new Boolean(boolVal);
            }
        }
        Object value = rs.getObject(index);
        return rs.wasNull() ? null : value;
    }

    public static void setObject(PreparedStatement stmt, int index, Object value, int sqlType) throws SQLException {
        if (value == null) {
            stmt.setNull(index, sqlType);
        } else {
            switch (sqlType) {
                case 6: 
                case 8: {
                    stmt.setDouble(index, (Double)value);
                    break;
                }
                case 7: {
                    stmt.setFloat(index, ((Float)value).floatValue());
                    break;
                }
                case 2004: {
                    try {
                        InputStream stream = (InputStream)value;
                        stmt.setBinaryStream(index, stream, stream.available());
                        break;
                    }
                    catch (IOException ex) {
                        throw new SQLException(ex.toString());
                    }
                }
                case 2005: {
                    Clob clob = (Clob)value;
                    stmt.setCharacterStream(index, clob.getCharacterStream(), (int)Math.min(clob.length(), Integer.MAX_VALUE));
                    break;
                }
                default: {
                    stmt.setObject(index, value, sqlType);
                }
            }
        }
    }

    public static TypeConvertor getConvertor(Class fromType, Class toType) throws MappingException {
        int i;
        for (i = 0; i < _typeConvertors.length; ++i) {
            if (!SQLTypes._typeConvertors[i].fromType.equals(fromType) || !toType.equals(SQLTypes._typeConvertors[i].toType)) continue;
            return SQLTypes._typeConvertors[i].convertor;
        }
        for (i = 0; i < _typeConvertors.length; ++i) {
            if (!SQLTypes._typeConvertors[i].fromType.isAssignableFrom(fromType) || !toType.isAssignableFrom(SQLTypes._typeConvertors[i].toType)) continue;
            return SQLTypes._typeConvertors[i].convertor;
        }
        throw new MappingException("mapping.noConvertor", fromType.getName(), toType.getName());
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat clone = (SimpleDateFormat)_dateFormat.clone();
        return clone;
    }

    private static SimpleDateFormat getParamDateFormat() {
        SimpleDateFormat clone = (SimpleDateFormat)_paramDateFormat.clone();
        return clone;
    }

    private static DecimalFormat getDecimalFormat() {
        DecimalFormat clone = (DecimalFormat)_decimalFormat.clone();
        return clone;
    }

    private static abstract class SQLTypeConvertor
    implements TypeConvertor {
        Class fromType;
        Class toType;

        SQLTypeConvertor(Class fromType, Class toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public abstract Object convert(Object var1, String var2);

        public String toString() {
            return this.fromType.getName() + "-->" + this.toType.getName();
        }
    }

    static class TypeConvertorInfo {
        final Class toType;
        final Class fromType;
        final SQLTypeConvertor convertor;

        TypeConvertorInfo(SQLTypeConvertor convertor) {
            this.convertor = convertor;
            this.fromType = convertor.fromType;
            this.toType = convertor.toType;
        }
    }

    static class TypeInfo {
        final int sqlType;
        final String sqlTypeName;
        final Class javaType;

        TypeInfo(int sqlType, String sqlTypeName, Class javaType) {
            this.sqlType = sqlType;
            this.sqlTypeName = sqlTypeName;
            this.javaType = javaType;
        }
    }
}

