/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcorej.util;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.i18n.TimeZone;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CCLHighResolutionTime {
    private static CCLHighResolutionTime singleton = null;
    public static final int I18N_DATETIME_FORMAT_DATE = 0;
    public static final int I18N_DATETIME_FORMAT_TIME = 1;
    public static final int I18N_DATETIME_FORMAT_DATETIME = 2;
    public static final int I18N_DATETIME_STYLE_FULL = 0;
    public static final int I18N_DATETIME_STYLE_LONG = 1;
    public static final int I18N_DATETIME_STYLE_MEDIUM = 2;
    public static final int I18N_DATETIME_STYLE_SHORT = 3;
    protected int m_I18NDateTimeFormatType = 2;
    protected int m_I18NDateTimeFormatStyle = 3;
    protected long m_TimeZoneOffset = 0L;
    private int m_DateTimeFormatType = 11;
    private int m_DateTimeFormatDateStyle = 3;
    private int m_DateTimeFormatTimeStyle = 3;
    private TimeZone m_TimeZone = null;
    private DateTimeFormat m_DateTimeFormat = null;
    private SimpleDateFormat m_userPatternFormatter = null;

    protected CCLHighResolutionTime() {
        this.allocDependents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCLHighResolutionTime getInstance() {
        if (singleton != null) return singleton;
        Class<CCLHighResolutionTime> clazz = CCLHighResolutionTime.class;
        synchronized (CCLHighResolutionTime.class) {
            if (singleton != null) return singleton;
            singleton = new CCLHighResolutionTime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void resetFormatTypeStyle(int type, int style) {
        this.m_userPatternFormatter = null;
        if (this.m_I18NDateTimeFormatType != type || this.m_I18NDateTimeFormatStyle != style) {
            this.m_I18NDateTimeFormatType = type;
            this.m_I18NDateTimeFormatStyle = style;
            this.allocDependents();
        }
    }

    public synchronized void setFormatPattern(String userPattern) {
        this.m_userPatternFormatter = new SimpleDateFormat(userPattern);
    }

    private void allocDependents() {
        switch (this.m_I18NDateTimeFormatType) {
            case 0: {
                this.m_DateTimeFormatType = 10;
                break;
            }
            case 1: {
                this.m_DateTimeFormatType = 12;
                break;
            }
            case 2: {
                this.m_DateTimeFormatType = 11;
            }
        }
        switch (this.m_I18NDateTimeFormatStyle) {
            case 0: {
                this.m_DateTimeFormatDateStyle = 0;
                this.m_DateTimeFormatTimeStyle = 0;
                break;
            }
            case 1: {
                this.m_DateTimeFormatDateStyle = 1;
                this.m_DateTimeFormatTimeStyle = 1;
                break;
            }
            case 2: {
                this.m_DateTimeFormatDateStyle = 2;
                this.m_DateTimeFormatTimeStyle = 2;
                break;
            }
            default: {
                this.m_DateTimeFormatDateStyle = 3;
                this.m_DateTimeFormatTimeStyle = 3;
            }
        }
        Locale locale = new Locale("");
        this.m_TimeZone = new TimeZone();
        this.m_DateTimeFormat = new DateTimeFormat(locale, this.m_DateTimeFormatType, this.m_DateTimeFormatDateStyle, this.m_DateTimeFormatTimeStyle);
        TimeZone theGMTTimeZone = new TimeZone("UTC");
        this.m_TimeZoneOffset = (long)(this.m_TimeZone.getRawOffset() - theGMTTimeZone.getRawOffset()) / 3600000L;
    }

    private long getCurrentLocalTime() {
        return System.currentTimeMillis();
    }

    private long getCurrentGMTTime() {
        long result = 0L;
        result = this.getCurrentLocalTime() + (long)this.m_TimeZone.getRawOffset();
        return result;
    }

    public long getTimeZoneOffset() {
        return this.m_TimeZoneOffset;
    }

    public String getTimeZoneID() {
        return this.m_TimeZone.getID();
    }

    public synchronized long getLocalTime() {
        return this.getCurrentLocalTime();
    }

    public synchronized String getLocalTimeString() {
        Date dateValue = new Date(this.getCurrentLocalTime());
        if (this.m_userPatternFormatter != null) {
            return this.m_userPatternFormatter.format(dateValue);
        }
        return this.m_DateTimeFormat.format(dateValue);
    }

    public synchronized long getGMTTime() {
        return this.getCurrentGMTTime();
    }

    public synchronized String getGMTTimeString() {
        Date dateValue = new Date(this.getCurrentGMTTime());
        if (this.m_userPatternFormatter != null) {
            return this.m_userPatternFormatter.format(dateValue);
        }
        return this.m_DateTimeFormat.format(dateValue);
    }
}

