/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cclcorej.util;

import com.cognos.ccl4j.exceptions.CCLIllegalArgumentException;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CCLResourceCounterSet
implements Externalizable {
    protected boolean rcs_isActive = true;
    protected String resourceID = null;
    protected CCLResourceCounterSet parent = null;
    protected int depth = 0;
    protected long CCLRESOURCECPUTIMER_TICKS = 1L;
    protected long m_cpuTime = 0L;
    protected long m_elapsedTime = 0L;
    protected long m_startTime = 0L;
    protected int m_memory = 0;
    protected int m_diskOps = 0;
    protected long m_diskIO = 0L;
    protected int m_commOps = 0;
    protected long m_commIO = 0L;
    public static final byte CPUTIME = 1;
    public static final byte MEMORY = 2;
    public static final byte DISKOPS = 3;
    public static final byte DISKIO = 4;
    public static final byte COMMOPS = 5;
    public static final byte COMMIO = 6;
    public static final byte ELAPSEDTIME = 7;

    public CCLResourceCounterSet() {
        this.parent = null;
    }

    public CCLResourceCounterSet(String resourceID, CCLResourceCounterSet parent) {
        this.resourceID = resourceID;
        this.parent = parent;
        if (parent != null) {
            this.depth = parent.getDepth() + 1;
        }
    }

    public synchronized void reset() {
        this.m_elapsedTime = 0L;
        this.m_startTime = 0L;
        this.m_cpuTime = 0L;
        this.m_memory = 0;
        this.m_diskOps = 0;
        this.m_diskIO = 0L;
        this.m_commOps = 0;
        this.m_commIO = 0L;
    }

    public synchronized void enableResourceCounter() {
        this.rcs_isActive = true;
        this.startElapsedTimer();
    }

    public synchronized void disableResourceCounter() {
        this.rcs_isActive = false;
        this.stopElapsedTimer();
    }

    private void startElapsedTimer() {
        this.m_startTime = System.currentTimeMillis();
    }

    private void stopElapsedTimer() {
        this.m_elapsedTime += System.currentTimeMillis() - this.m_startTime;
    }

    public long getElapsedTime() {
        return this.m_elapsedTime;
    }

    public void incrementResource(byte type, long delta) {
        this.updateResource(type, delta);
    }

    public void decrementResource(byte type, long delta) {
        this.updateResource(type, -delta);
    }

    public synchronized void updateResource(byte type, long delta) {
        if (1 == type || 7 == type) {
            return;
        }
        if (this.rcs_isActive) {
            switch (type) {
                case 2: {
                    this.m_memory = (int)((long)this.m_memory + delta);
                    break;
                }
                case 3: {
                    this.m_diskOps = (int)((long)this.m_diskOps + delta);
                    break;
                }
                case 4: {
                    this.m_diskIO += delta;
                    ++this.m_diskOps;
                    break;
                }
                case 5: {
                    this.m_commOps = (int)((long)this.m_commOps + delta);
                    break;
                }
                case 6: {
                    this.m_commIO += delta;
                    ++this.m_commOps;
                }
            }
            if (this.parent != null) {
                this.parent.updateResource(type, delta);
            }
        }
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public int getDepth() {
        return this.depth;
    }

    public String resourceToString(byte type) throws CCLIllegalArgumentException {
        String value = null;
        switch (type) {
            case 1: {
                value = Double.toString((double)this.m_cpuTime / (double)this.CCLRESOURCECPUTIMER_TICKS);
                break;
            }
            case 7: {
                value = Long.toString(this.m_elapsedTime);
                break;
            }
            case 2: {
                value = Integer.toString(this.m_memory);
                break;
            }
            case 3: {
                value = Integer.toString(this.m_diskOps);
                break;
            }
            case 4: {
                value = Long.toString(this.m_diskIO);
                break;
            }
            case 5: {
                value = Integer.toString(this.m_commOps);
                break;
            }
            case 6: {
                value = Long.toString(this.m_commIO);
                break;
            }
            default: {
                throw new CCLIllegalArgumentException("Invalid Resource Type");
            }
        }
        return value;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        try {
            out.writeUTF(this.resourceID);
            out.writeLong(this.m_cpuTime);
            out.writeInt(this.m_memory);
            out.writeInt(this.m_diskOps);
            out.writeLong(this.m_diskIO);
            out.writeInt(this.m_commOps);
            out.writeLong(this.m_commIO);
            out.writeLong(this.m_startTime);
            out.writeLong(this.m_elapsedTime);
            out.writeLong(this.CCLRESOURCECPUTIMER_TICKS);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput in) {
        try {
            this.resourceID = in.readUTF();
            this.m_cpuTime = in.readLong();
            this.m_memory = in.readInt();
            this.m_diskOps = in.readInt();
            this.m_diskIO = in.readLong();
            this.m_commOps = in.readInt();
            this.m_commIO = in.readLong();
            this.m_startTime = in.readLong();
            this.m_elapsedTime = in.readLong();
            this.CCLRESOURCECPUTIMER_TICKS = in.readLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

