/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.annotations;

import com.cognos.ccs.annotations.AnnotationSession;
import com.cognos.ccs.annotations.ReverseContextMap;
import com.cognos.ccs.context.ContextIterator;
import com.cognos.ccs.drill.MetadataMap;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.Utilities;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class AnnotationConnector {
    public static final int MEASURE = 0;
    public static final int ROW = 1;
    public static final int COLUMN = 2;
    public static final int SECTION = 3;

    public String getAnnotations(ContextIterator contextIterator, MetadataMap metadataMap, AnnotationSession annotationSession) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        Document document = annotationSession.getAnnotationServiceResponse();
        String string = document.asXML();
        CCSLogger.getInstance().logSystemResponse(string, "ans:readAnnotationByParentIdResponse: " + annotationSession.parentStoreId, annotationSession.secondaryStoreId);
        List<Annotation> list = this.parseAnnotations(document);
        String string2 = AnnotationConnector.getAnnotationMapInJSON(metadataMap, contextIterator, list);
        return string2;
    }

    public Element getAnnotationSpecs(AnnotationSession annotationSession) throws CCSGeneralException, CCSAuthenticationException {
        Document document = annotationSession.getAnnotationServiceResponse();
        List<Element> list = AnnotationConnector.selectElementsWithXPath("//SOAP-ENV:Envelope/SOAP-ENV:Body/ans:readAnnotationByParentIdResponse/ans:annotations", document.getRootElement());
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public static List<Annotation> getAnnotationMapAsList(MetadataMap metadataMap, ContextIterator contextIterator, List<Annotation> list) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        ReverseContextMap reverseContextMap = new ReverseContextMap(contextIterator, metadataMap, list);
        for (Annotation annotation : list) {
            Annotation annotation2 = AnnotationConnector.processAnnotationContext(annotation, reverseContextMap);
            if (annotation2 == null) continue;
            arrayList.add(annotation2);
        }
        return arrayList;
    }

    public static String getAnnotationMapInJSON(MetadataMap metadataMap, ContextIterator contextIterator, List<Annotation> list) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        JSONArray jSONArray = new JSONArray();
        if (list.size() == 0) {
            return "empty";
        }
        ReverseContextMap reverseContextMap = new ReverseContextMap(contextIterator, metadataMap, list);
        for (Annotation annotation : list) {
            Annotation annotation2 = AnnotationConnector.processAnnotationContext(annotation, reverseContextMap);
            if (annotation2 == null) continue;
            try {
                OrderedJSONObject orderedJSONObject = new OrderedJSONObject();
                if (!"".equals(annotation2.name)) {
                    orderedJSONObject.put((Object)"ctx", (Object)annotation2.name);
                }
                if (annotation2.dataItem != null) {
                    orderedJSONObject.put((Object)"rdi", (Object)annotation2.dataItem);
                }
                orderedJSONObject.put((Object)"ann", (Object)annotation2.value);
                if (annotation2.layoutElementId != null) {
                    orderedJSONObject.put((Object)"layoutElementId", (Object)annotation2.layoutElementId);
                }
                orderedJSONObject.put((Object)"desc", (Object)annotation2.description);
                orderedJSONObject.put((Object)"ct", (Object)annotation2.creationTime);
                orderedJSONObject.put((Object)"ctf", (Object)annotation2.creationTimeFormatted);
                orderedJSONObject.put((Object)"owner", (Object)annotation2.defaultName);
                orderedJSONObject.put((Object)"ownerSearchPath", (Object)annotation2.ownerSearchPath);
                if (annotation2.filterDetails != null) {
                    orderedJSONObject.put((Object)"fd", (Object)annotation2.filterDetails);
                }
                if (annotation2.parameterValues != null) {
                    orderedJSONObject.put((Object)"pv", (Object)annotation2.parameterValues);
                }
                if (annotation2.sliderDetails != null) {
                    orderedJSONObject.put((Object)"sd", (Object)annotation2.sliderDetails);
                }
                if (annotation2.lastModificationTime != null) {
                    orderedJSONObject.put((Object)"lmt", (Object)annotation2.lastModificationTime);
                }
                if (annotation2.lastModificationTime != null) {
                    orderedJSONObject.put((Object)"lmtf", (Object)annotation2.lastModificationTimeFormatted);
                }
                if (annotation2.version != null) {
                    orderedJSONObject.put((Object)"version", (Object)annotation2.version);
                }
                jSONArray.add((Object)orderedJSONObject);
            }
            catch (Exception exception) {
                CCSGeneralException cCSGeneralException = new CCSGeneralException("ANNOTATION_ERROR", exception, 500);
                CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), "ann", "ann", "ann", cCSGeneralException.getSourceTrace());
                throw cCSGeneralException;
            }
        }
        return jSONArray.toString();
    }

    public static Annotation processAnnotationContext(Annotation annotation, ReverseContextMap reverseContextMap) {
        annotation.name = "";
        boolean bl = false;
        String string = "";
        String[] stringArray = new String[]{"", "", "", ""};
        String[][] stringArray2 = annotation.dilist;
        for (int i = 0; i < stringArray2.length; ++i) {
            string = stringArray2[i][3];
            bl = string.equalsIgnoreCase("true") || string.equals("1");
            String string2 = annotation.query;
            if (null != stringArray2[i][4]) {
                string2 = stringArray2[i][4];
            }
            String string3 = reverseContextMap.getContextNumber(string2, stringArray2[i][0], stringArray2[i][1]);
            if (!bl && string3 == null) {
                return null;
            }
            String string4 = bl ? "*" : string3;
            int n = AnnotationConnector.getTypeIndex(stringArray2[i][2]);
            if (!stringArray[n].equals("")) {
                int n2 = n;
                stringArray[n2] = stringArray[n2] + ":";
            }
            int n3 = n;
            stringArray[n3] = stringArray[n3] + string4;
        }
        if (!stringArray[0].equals("")) {
            annotation.name = stringArray[0] + "::" + stringArray[1] + "::" + stringArray[2];
            if (!stringArray[3].equals("")) {
                annotation.name = annotation.name + "::";
                annotation.name = annotation.name + stringArray[3];
            }
        } else {
            annotation.name = stringArray[2];
        }
        return annotation;
    }

    private static int getTypeIndex(String string) {
        if (string.equals("column")) {
            return 2;
        }
        if (string.equals("measure")) {
            return 0;
        }
        if (string.equals("section")) {
            return 3;
        }
        return 1;
    }

    public List<Annotation> parseAnnotations(Document document) throws CCSGeneralException {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        List<Element> list = AnnotationConnector.selectElementsWithXPath("//SOAP-ENV:Envelope/SOAP-ENV:Body/ans:readAnnotationByParentIdResponse/ans:annotations/ans:annotation", document.getRootElement());
        for (Element element : list) {
            Element element2;
            Element element3;
            Annotation annotation = new Annotation();
            List<Element> list2 = AnnotationConnector.selectElementsWithXPath("./ans:context/selections", element);
            if (list2.size() > 0) {
                Element element4;
                int n;
                element3 = this.processAnnotation(element, "./ans:context/selections/query/selection/measures/measure");
                element2 = this.processAnnotation(element, "./ans:context/selections/query/selection/rows/row");
                String[][] stringArray = this.processAnnotation(element, "./ans:context/selections/query/selection/columns/column");
                String[][] stringArray2 = this.processAnnotation(element, "./ans:context/selections/query/selection/sections/section");
                String[][] stringArrayArray = new String[((Element)element3).length + ((String[][])element2).length + stringArray.length + stringArray2.length][];
                int n2 = 0;
                for (n = 0; n < ((Element)element3).length; ++n) {
                    stringArrayArray[n2] = element3[n];
                    ++n2;
                }
                for (n = 0; n < ((Element)element2).length; ++n) {
                    stringArrayArray[n2] = element2[n];
                    ++n2;
                }
                for (n = 0; n < stringArray.length; ++n) {
                    stringArrayArray[n2] = stringArray[n];
                    ++n2;
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    stringArrayArray[n2] = stringArray2[n];
                    ++n2;
                }
                if (stringArrayArray.length > 0) {
                    annotation.dataItem = stringArrayArray[0][0];
                }
                annotation.layoutElementId = (element4 = AnnotationConnector.selectElementsWithXPath("./ans:context/selections/query/selection/layoutElementId", element).get(0)).getText() == null ? "*" : element4.getText();
                annotation.query = element.element("context").element("selections").element("query").attributeValue("name");
                annotation.dilist = stringArrayArray;
            } else {
                annotation.dilist = new String[0][];
            }
            element3 = element.element("id");
            annotation.value = element3.getText();
            annotation.creationTime = element.elementText("creationTime");
            annotation.creationTimeFormatted = element.elementText("creationTimeFormatted");
            element2 = element.element("owner");
            if (element2 != null && (element2 = element2.element("CMRef")) != null) {
                annotation.defaultName = element2.elementText("defaultName");
                annotation.ownerSearchPath = element2.elementText("searchPath");
            }
            annotation.description = element.elementText("description");
            annotation.populateTags(element.element("tags"));
            annotation.lastModificationTime = element.elementText("lastModificationTime");
            annotation.lastModificationTimeFormatted = element.elementText("lastModificationTimeFormatted");
            arrayList.add(annotation);
        }
        return arrayList;
    }

    private String[][] processAnnotation(Element element, String string) {
        List<Element> list = AnnotationConnector.selectElementsWithXPath(string, element);
        String[][] stringArray = new String[list.size()][];
        int n = 0;
        for (Element element2 : list) {
            String string2 = element2.attribute("order").getText();
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
            stringArray[n] = new String[5];
            Element element3 = element2.element("item");
            Element element4 = element3.element("name");
            String string3 = "false";
            Element element5 = (Element)element3.selectSingleNode("value/item/use");
            String string4 = element5.getText();
            Element element6 = element2.element("selectAll");
            if (element6 != null) {
                string3 = element6.getText();
            }
            if ("true".equals(string3) || "1".equals(string3)) {
                string3 = "true";
            } else {
                int n2 = 0;
                try {
                    String string5 = element2.attribute("usage").getText();
                    if (string5 != null) {
                        n2 = Integer.parseInt(string5);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 == 2) {
                    string3 = "true";
                }
                if (n2 == 3) {
                    if (Utilities.isNullOrBlank(string4)) {
                        string3 = "true";
                    } else {
                        try {
                            Double.parseDouble(string4);
                            string3 = "true";
                        }
                        catch (NumberFormatException numberFormatException) {
                            string3 = "false";
                        }
                    }
                }
            }
            stringArray[n][0] = element4.getText();
            stringArray[n][1] = string4;
            stringArray[n][2] = element2.getName();
            stringArray[n][3] = string3;
            stringArray[n][4] = element2.attributeValue("qry");
        }
        return stringArray;
    }

    public static List<Element> selectElementsWithXPath(String string, Element element) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("ans", "http://www.ibm.com/xmlns/prod/cognos/internal/annotationService");
        simpleNamespaceContext.addNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        XPath xPath = element.createXPath(string);
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list = xPath.selectNodes((Object)element);
        return list;
    }

    public static class Annotation {
        public String[][] dilist;
        public String name;
        public String dataItem;
        public String query;
        public String value;
        public String layoutElementId;
        public String description;
        public String creationTimeFormatted;
        public String defaultName;
        public String creationTime;
        public String parameterValues;
        public String sliderDetails;
        public String filterDetails;
        public String lastModificationTime;
        public String lastModificationTimeFormatted;
        public String ownerSearchPath;
        public String version = "1";

        public void populateTags(Element element) {
            if (element != null) {
                Iterator iterator = element.elementIterator("tag");
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    if ("parameterValues".equals(element2.elementText("name"))) {
                        this.parameterValues = element2.elementText("value");
                        continue;
                    }
                    if ("filterDetails".equals(element2.elementText("name"))) {
                        this.filterDetails = element2.elementText("value");
                        continue;
                    }
                    if ("sliderDetails".equals(element2.elementText("name"))) {
                        this.sliderDetails = element2.elementText("value");
                        continue;
                    }
                    if (!"version".equals(element2.elementText("name"))) continue;
                    this.version = element2.elementText("value");
                }
            }
        }
    }
}

