/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.annotations;

import com.cognos.ccs.annotations.AAnnotationSession;
import com.cognos.ccs.annotations.AnnotationConnector;
import com.cognos.ccs.annotations.ContextSelection;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.HTTPRequest;
import com.cognos.ccs.context.ContextIterator;
import com.cognos.ccs.context.StringContextIterator;
import com.cognos.ccs.drill.ContextData;
import com.cognos.ccs.drill.ContextList;
import com.cognos.ccs.drill.MetadataMap;
import com.cognos.ccs.exceptions.CCSAnnAuthenticationException;
import com.cognos.ccs.exceptions.CCSAnnGeneralException;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.LinkedHashMap;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class AnnotationSession
implements AAnnotationSession {
    private static final String PRIMARY_KEY = "primary";
    ContentProvider provider;
    Conversation conversation;
    private AnnotationConnector m_annotationConnector = new AnnotationConnector();
    String parentStoreId;
    String secondaryStoreId;
    Cookie[] cookies;
    BIBusEnvelope envelope;

    public AnnotationSession() {
    }

    public AnnotationSession(String string) {
        this.parentStoreId = string;
    }

    public AnnotationSession(String string, String string2, Cookie[] cookieArray) {
        this(string, string2, cookieArray, null);
    }

    public AnnotationSession(String string, String string2, Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope) {
        this.parentStoreId = string;
        this.secondaryStoreId = string2;
        this.cookies = cookieArray;
        this.envelope = bIBusEnvelope;
    }

    public AnnotationSession(String string, String string2, String string3, AsynchRequest asynchRequest, BIBusEnvelope bIBusEnvelope) throws CCSGeneralException, CCSAuthenticationException {
        Cognos8Connector cognos8Connector = new Cognos8Connector();
        cognos8Connector.connectToReportServer();
        cognos8Connector.populateSDKBiBus(bIBusEnvelope);
        this.envelope = bIBusEnvelope;
        this.init(string, string2, string3, asynchRequest, cognos8Connector.getCognosRSService());
    }

    public AnnotationSession(String string, String string2, String string3, AsynchRequest asynchRequest, BiBusHeader biBusHeader) throws CCSGeneralException, CCSAuthenticationException {
        this.init(string, string2, string3, asynchRequest, biBusHeader);
    }

    protected void init(String string, String string2, String string3, AsynchRequest asynchRequest, BiBusHeader biBusHeader) throws CCSGeneralException, CCSAuthenticationException {
        CommandSession commandSession = new CommandSession();
        this.secondaryStoreId = string2;
        Cognos8Connector cognos8Connector = new Cognos8Connector();
        this.conversation = new Conversation(biBusHeader);
        Conversation.serializeAsyncRequest(this.conversation, asynchRequest, PRIMARY_KEY);
        this.conversation.setProperty("versionPath", string3);
        cognos8Connector.connectToReportServer();
        this.provider = ContentProvider.getProvider(string, cognos8Connector, null, commandSession);
        this.parentStoreId = this.provider.getStoreID();
    }

    @Override
    public String getAnnotations(String string, String string2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        StringContextIterator stringContextIterator = new StringContextIterator(string);
        MetadataMap metadataMap = new MetadataMap(string2);
        String string3 = this.m_annotationConnector.getAnnotations(stringContextIterator, metadataMap, this);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("contextJSON", string);
        linkedHashMap.put("metadataJSON", string2);
        linkedHashMap.put("result", string3);
        CCSLogger.getInstance().logUserRequest("com.cognos.ccs.annotations.AnnotationSession.getAnnotations", linkedHashMap, this.parentStoreId, this.secondaryStoreId);
        return string3;
    }

    @Override
    public String addAnnotation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.logAddRequest(string, string2, string3, string4, string5, string6, string7, string8);
        ContextList contextList = new ContextList(string);
        MetadataMap metadataMap = new MetadataMap(string2);
        ContextSelection contextSelection = new ContextSelection(contextList, metadataMap, string4, string3, string5, this.parentStoreId, this.secondaryStoreId, string6, string7, string8);
        String string9 = contextSelection.xmlValue();
        String string10 = this.createAnnotation(string9);
        return string10;
    }

    private void logAddRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("contextJSON", string);
        linkedHashMap.put("metadataJSON", string2);
        linkedHashMap.put("contextId", string3);
        linkedHashMap.put("text", string4);
        linkedHashMap.put("layoutElementId", string5);
        linkedHashMap.put("parameterValues", string6);
        linkedHashMap.put("sliderDetails", string7);
        linkedHashMap.put("filterDetails", string8);
        CCSLogger.getInstance().logUserRequest("com.cognos.ccs.annotations.AnnotationSession.addAnnotation", linkedHashMap, this.parentStoreId, this.secondaryStoreId);
    }

    @Override
    public String getAnnotations() throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        ContextIterator contextIterator = new ContextIterator(this.provider, this.conversation);
        MetadataMap metadataMap = this.provider.getMetaDataMap(this.conversation);
        String string = this.m_annotationConnector.getAnnotations(contextIterator, metadataMap, this);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("result", string);
        CCSLogger.getInstance().logUserRequest("com.cognos.ccs.annotations.AnnotationSession.getAnnotations", linkedHashMap, this.parentStoreId, this.secondaryStoreId);
        return string;
    }

    @Override
    public String addAnnotation(String string, String string2, String string3, String string4, String string5, String string6) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.logAddRequest(null, null, string, string2, string3, string4, string5, string6);
        ContextData contextData = this.provider.getDataContext(this.conversation, string);
        ContextList contextList = contextData.contextList();
        MetadataMap metadataMap = contextData.metadataMap();
        ContextSelection contextSelection = new ContextSelection(contextList, metadataMap, string2, string, string3, this.parentStoreId, this.secondaryStoreId, string4, string5, string6);
        String string7 = contextSelection.xmlValue();
        String string8 = this.createAnnotation(string7);
        return string8;
    }

    public Document getAnnotationServiceResponse() throws CCSGeneralException, CCSAuthenticationException {
        Document document;
        HTTPRequest hTTPRequest = new HTTPRequest(this.cookies, this.envelope);
        String string = "<ans:readAnnotationByParentId xmlns:ans=\"http://www.ibm.com/xmlns/prod/cognos/internal/annotationService\"><ans:annotation><ans:parentId>" + this.parentStoreId + "</ans:parentId>";
        if (this.secondaryStoreId != null) {
            string = string + "<ans:secondaryParentId>" + this.secondaryStoreId + "</ans:secondaryParentId>";
        }
        string = string + "</ans:annotation></ans:readAnnotationByParentId>";
        hTTPRequest.setSoapRequestBody(string);
        try {
            document = Utilities.parseText(hTTPRequest.retrieveContent());
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException(CCLMessage.getResMessage("ANNOTATION_ERROR", ConfigMgr.getInstance().getServerLocale()), 500);
        }
        AnnotationSession.checkForSOAPFaults(document);
        return document;
    }

    public String createAnnotation(String string) throws CCSGeneralException, CCSAuthenticationException {
        HTTPRequest hTTPRequest = new HTTPRequest(this.cookies, this.envelope);
        hTTPRequest.setSoapRequestBody(string);
        CCSLogger.getInstance().logSystemRequest(string, "ans:createAnnotation request: " + this.parentStoreId, this.secondaryStoreId);
        String string2 = hTTPRequest.retrieveContent();
        String string3 = this.extractResponse(string2);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("response", string3);
        CCSLogger.getInstance().logUserRequest("com.cognos.ccs.annotations.AnnotationSession.addAnnotation REPLY", linkedHashMap, this.parentStoreId, this.secondaryStoreId);
        return string3;
    }

    private String extractResponse(String string) throws CCSGeneralException, CCSAuthenticationException {
        try {
            Document document = Utilities.parseText(string);
            AnnotationSession.checkForSOAPFaults(document);
            Element element = AnnotationConnector.selectElementsWithXPath("//SOAP-ENV:Envelope/SOAP-ENV:Body/ans:createAnnotationResponse/ans:annotation", document.getRootElement()).get(0);
            String string2 = element.asXML();
            return string2;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException(CCLMessage.getResMessage("ANNOTATION_ERROR", ConfigMgr.getInstance().getServerLocale()), 500);
        }
    }

    @Override
    public String addAnnotation(String string, String string2, String string3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.addAnnotation(string, string2, string3, null, null, null);
    }

    @Override
    public String addAnnotation(String string, String string2, String string3, String string4, String string5) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.addAnnotation(string, string2, string3, string4, string5, null, null, null);
    }

    protected static void checkForSOAPFaults(Document document) throws CCSAuthenticationException, CCSGeneralException {
        Element element = document.getRootElement().element("Header");
        if (element == null) {
            return;
        }
        Element element2 = element.element("biBusHeader");
        if (element2 == null) {
            return;
        }
        Element element3 = element2.element("CAM");
        if (element3 == null) {
            return;
        }
        Element element4 = element3.element("exception");
        if (element4 != null) {
            throw new CCSAnnAuthenticationException(element4);
        }
        Element element5 = document.getRootElement().element("Body");
        Element element6 = element5.element("Fault");
        if (element6 != null) {
            throw new CCSAnnGeneralException(element6);
        }
    }
}

